/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xtreemfs.dir.DIRConfig;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.data.ServiceRecords;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class MonitoringThread
extends LifeCycleThread {
    private final DIRConfig cfg;
    private final int sleep;
    private final Map<String, Integer> warnCount;
    private volatile boolean quit;
    private final DIRRequestDispatcher master;

    public MonitoringThread(DIRConfig config, DIRRequestDispatcher master) {
        super("MonThr");
        this.master = master;
        this.cfg = config;
        this.sleep = this.cfg.getTimeoutSeconds() / 2 * 1000;
        this.warnCount = new HashMap<String, Integer>();
    }

    @Override
    public void run() {
        this.notifyStarted();
        Logging.logMessage(6, Logging.Category.lifecycle, this, "MonitoringThread started", new Object[0]);
        do {
            try {
                MonitoringThread.sleep(this.sleep);
            }
            catch (InterruptedException ex) {
                break;
            }
            long now = System.currentTimeMillis() / 1000L;
            try {
                ServiceRecords services = this.master.getServices();
                LinkedList<String> offlineServices = new LinkedList<String>();
                boolean sendWarning = false;
                for (ServiceRecord srv : services.getList()) {
                    if (srv.getType() == DIR.ServiceType.SERVICE_TYPE_VOLUME) continue;
                    if (srv.getLast_updated_s() < now + (long)this.cfg.getTimeoutSeconds()) {
                        int wc = 0;
                        if (this.warnCount.get(srv.getUuid()) != null) {
                            wc = this.warnCount.get(srv.getUuid());
                        }
                        String str = srv.getUuid() + "/" + srv.getName() + " - " + (srv.getLast_updated_s() == 0L ? "service was shut down" : "last heartbeat " + new Date(srv.getLast_updated_s() * 1000L));
                        offlineServices.add(str);
                        this.warnCount.put(srv.getUuid(), ++wc);
                        if (wc > this.cfg.getMaxWarnings()) continue;
                        sendWarning = true;
                        Logging.logMessage(6, Logging.Category.net, this, "service is offline: %s", str);
                        continue;
                    }
                    this.warnCount.remove(srv.getUuid());
                }
                if (!sendWarning || this.cfg.getAdminEmail().length() <= 0) continue;
                StringBuilder sendmailData = new StringBuilder();
                sendmailData.append("To: " + this.cfg.getAdminEmail());
                sendmailData.append("\n");
                if (this.cfg.getSenderAddress().length() > 0) {
                    sendmailData.append("From: " + this.cfg.getSenderAddress());
                    sendmailData.append("\n");
                }
                sendmailData.append("Subject: XtreemFS service(s) offline\n");
                sendmailData.append("The following service(s) did not send a heartbeat signal for at least " + this.cfg.getTimeoutSeconds() + " seconds: \n\n");
                for (String srv : offlineServices) {
                    sendmailData.append(srv);
                    sendmailData.append("\n");
                }
                sendmailData.append("\n--END--\n.\n");
                Process p = Runtime.getRuntime().exec(this.cfg.getSendmailBin() + " -t " + this.cfg.getAdminEmail());
                OutputStream os = p.getOutputStream();
                os.write(sendmailData.toString().getBytes());
                os.close();
                p.waitFor();
                Logging.logMessage(6, Logging.Category.net, this, "sent email to %s", this.cfg.getAdminEmail());
            }
            catch (Exception ex) {
                Logging.logError(6, (Object)Logging.Category.all, ex);
            }
        } while (!this.quit);
        this.notifyStopped();
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }
}

