/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.common.statusserver.StatusServerHelper;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class ReplicaStatusPage
extends StatusServerModule {
    private DIRRequestDispatcher master;
    private final String statusPageTemplate;

    public ReplicaStatusPage() {
        StringBuffer sb = StatusServerHelper.readTemplate("org/xtreemfs/dir/templates/replica_status.html");
        this.statusPageTemplate = sb == null ? "<h1>Template was not found, unable to show status page!</h1>" : sb.toString();
    }

    @Override
    public String getDisplayName() {
        return "Replica Status Summary";
    }

    @Override
    public String getUriPath() {
        return "/replica_status";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_DIR;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_DIR);
        this.master = (DIRRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String uriPath = httpExchange.getRequestURI().getPath();
        if (uriPath.equals("/replica_status/d3.v3.js")) {
            StatusServerHelper.sendFile("org/xtreemfs/dir/templates/d3.v3.js", httpExchange);
        } else if (uriPath.equals("/replica_status")) {
            this.handleStatusPage(httpExchange);
        } else {
            httpExchange.sendResponseHeaders(404, -1L);
            httpExchange.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStatusPage(HttpExchange httpExchange) throws IOException {
        HashMap osds = new HashMap();
        ResultSet iter = null;
        try {
            Database database = this.master.getDirDatabase();
            iter = (ResultSet)database.prefixLookup(1, new byte[0], null).get();
            while (iter.hasNext()) {
                Map.Entry e = (Map.Entry)iter.next();
                String uuid = new String((byte[])e.getKey());
                ServiceRecord sreg = new ServiceRecord(ReusableBuffer.wrap((byte[])e.getValue()));
                if (sreg.getType() != DIR.ServiceType.SERVICE_TYPE_OSD) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("uuid", sreg.getUuid());
                data.put("name", sreg.getName());
                for (Map.Entry<String, String> dataEntry : sreg.getData().entrySet()) {
                    if (!dataEntry.getKey().equals("status_page_url")) continue;
                    data.put("status_page_url", dataEntry.getValue());
                }
                if (!data.containsKey("status_page_url") || sreg.getLast_updated_s() == 0L) continue;
                osds.put(sreg.getUuid(), data);
            }
            String osdsJSON = JSONParser.writeJSON(osds);
            this.sendResponse(httpExchange, this.statusPageTemplate.replace(Vars.OSDSJSON.toString(), osdsJSON));
        }
        catch (BabuDBException ex) {
            Logging.logError(4, null, ex);
            httpExchange.sendResponseHeaders(500, 0L);
        }
        catch (JSONException ex) {
            Logging.logError(4, null, ex);
            httpExchange.sendResponseHeaders(500, 0L);
        }
        finally {
            httpExchange.close();
            if (iter != null) {
                iter.free();
            }
        }
    }

    private static enum Vars {
        OSDSJSON("<!-- $OSDSJSON -->");

        private String template;

        private Vars(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

