/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.common.statusserver.StatusServerHelper;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.dir.DIRConfig;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.AddressMappingRecord;
import org.xtreemfs.dir.data.AddressMappingRecords;
import org.xtreemfs.dir.data.ConfigurationRecord;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class StatusPage
extends StatusServerModule {
    private DIRRequestDispatcher master;
    private final DIRConfig config;
    private final String statusPageTemplate;
    private static final int SERVICE_TIMEOUT = 600000;

    public StatusPage(DIRConfig config) {
        StringBuffer sb = StatusServerHelper.readTemplate("org/xtreemfs/dir/templates/status.html");
        this.statusPageTemplate = sb == null ? "<h1>Template was not found, unable to show status page!</h1>" : sb.toString();
        this.config = config;
    }

    @Override
    public String getDisplayName() {
        return "DIR Status Summary";
    }

    @Override
    public String getUriPath() {
        return "/";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_DIR;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_DIR);
        this.master = (DIRRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        ResultSet addrMapsIter = null;
        ResultSet servRegIter = null;
        ResultSet confIter = null;
        try {
            String uuid;
            Map.Entry e;
            Database database = this.master.getDirDatabase();
            assert (this.statusPageTemplate != null);
            long time = System.currentTimeMillis();
            addrMapsIter = (ResultSet)database.prefixLookup(0, new byte[0], null).get();
            StringBuilder dump = new StringBuilder();
            dump.append("<br><table width=\"100%\" frame=\"box\"><td colspan=\"2\" class=\"heading\">Address Mapping</td>");
            dump.append("<tr><td class=\"dumpTitle\">UUID</td><td class=\"dumpTitle\">mapping</td></tr>");
            while (addrMapsIter.hasNext()) {
                e = (Map.Entry)addrMapsIter.next();
                AddressMappingRecords ams = new AddressMappingRecords(ReusableBuffer.wrap((byte[])e.getValue()));
                String uuid2 = new String((byte[])e.getKey());
                dump.append("<tr><td class=\"uuid\">");
                dump.append(uuid2);
                dump.append("</td><td class=\"dump\"><table width=\"100%\"><tr>");
                dump.append("<tr><td><table width=\"100%\">");
                long version = 0L;
                for (AddressMappingRecord addressMappingRecord : ams.getRecords()) {
                    dump.append("<tr><td class=\"mapping\">");
                    String endpoint = addressMappingRecord.getUri() + " (" + addressMappingRecord.getProtocol() + "," + addressMappingRecord.getAddress() + "," + addressMappingRecord.getPort() + ")";
                    dump.append(endpoint);
                    dump.append("</td><td class=\"mapping\">");
                    dump.append(addressMappingRecord.getMatch_network());
                    dump.append("</td><td class=\"mapping\">");
                    dump.append(addressMappingRecord.getTtl_s());
                    dump.append("</td></tr>");
                    version = addressMappingRecord.getVersion();
                }
                dump.append("</table></td></tr>");
                dump.append("<td class=\"version\">version: <b>");
                dump.append(version);
                dump.append("</b></td></tr></table>");
            }
            dump.append("</td></tr></table>");
            addrMapsIter.free();
            servRegIter = (ResultSet)database.prefixLookup(1, new byte[0], null).get();
            dump.append("<br><table width=\"100%\" frame=\"box\"><td colspan=\"2\" class=\"heading\">Service Registry</td>");
            dump.append("<tr><td class=\"dumpTitle\">UUID</td><td class=\"dumpTitle\">mapping</td></tr>");
            while (servRegIter.hasNext()) {
                e = (Map.Entry)servRegIter.next();
                uuid = new String((byte[])e.getKey());
                ServiceRecord sreg = new ServiceRecord(ReusableBuffer.wrap((byte[])e.getValue()));
                dump.append("<tr><td class=\"uuid\">");
                dump.append(uuid);
                dump.append("</td><td class=\"dump\"><table width=\"100%\">");
                dump.append("<tr><td width=\"30%\">");
                dump.append("type");
                dump.append("</td><td><b>");
                dump.append(sreg.getType());
                dump.append("</b></td></tr>");
                dump.append("<tr><td width=\"30%\">");
                dump.append("name");
                dump.append("</td><td><b>");
                dump.append(sreg.getName());
                dump.append("</b></td></tr>");
                TreeMap<String, String> sMap = new TreeMap<String, String>();
                for (Map.Entry<String, String> entry : sreg.getData().entrySet()) {
                    sMap.put(entry.getKey(), entry.getValue());
                }
                String osdHealthCheckOutput = (String)sMap.remove("osd_health_check_output");
                for (Map.Entry entry : sMap.entrySet()) {
                    dump.append("<tr><td width=\"30%\">");
                    dump.append((String)entry.getKey());
                    dump.append("</td><td><b>");
                    if (((String)entry.getKey()).equals("status_page_url")) {
                        dump.append("<a href=\"");
                        dump.append((String)entry.getValue());
                        dump.append("\">");
                    }
                    if (!((String)entry.getKey()).equals("static.status") && !((String)entry.getKey()).equals("osd_health_check")) {
                        dump.append((String)entry.getValue());
                    }
                    if (((String)entry.getKey()).equals("status_page_url")) {
                        dump.append("</a>");
                    } else if (!((String)entry.getKey()).equals("last_updated")) {
                        if (((String)entry.getKey()).equals("static.status")) {
                            DIR.ServiceStatus status = DIR.ServiceStatus.valueOf(Integer.valueOf((String)entry.getValue()));
                            switch (status) {
                                case SERVICE_STATUS_AVAIL: {
                                    dump.append("online (new files will be assigned to it)");
                                    break;
                                }
                                case SERVICE_STATUS_TO_BE_REMOVED: {
                                    dump.append("locked (new files will not be assigned to it)");
                                    break;
                                }
                                case SERVICE_STATUS_REMOVED: {
                                    dump.append("removed (replicas assigned to this OSD will be replaced)");
                                }
                            }
                        } else if (((String)entry.getKey()).equals("free") || ((String)entry.getKey()).equals("total") || ((String)entry.getKey()).endsWith("RAM") || ((String)entry.getKey()).equals("used")) {
                            dump.append(" bytes (");
                            dump.append(OutputUtils.formatBytes(Long.parseLong((String)entry.getValue())));
                            dump.append(")");
                        } else if (((String)entry.getKey()).equals("load")) {
                            dump.append("%");
                        } else if (((String)entry.getKey()).equals("vivaldi_coordinates")) {
                            GlobalTypes.VivaldiCoordinates coord = VivaldiNode.stringToCoordinates((String)entry.getValue());
                            dump.append(" (");
                            dump.append(coord.getXCoordinate());
                            dump.append(",");
                            dump.append(coord.getYCoordinate());
                            dump.append(" err ");
                            dump.append(coord.getLocalError());
                            dump.append(")");
                        } else if (((String)entry.getKey()).equals("osd_health_check")) {
                            switch (OSD.OSDHealthResult.valueOf(Integer.valueOf((String)entry.getValue()))) {
                                case OSD_HEALTH_RESULT_PASSED: {
                                    dump.append("passed (" + osdHealthCheckOutput + ")");
                                    break;
                                }
                                case OSD_HEALTH_RESULT_FAILED: {
                                    dump.append("<font color=#FF0000>failed (" + osdHealthCheckOutput + ")</font>");
                                    break;
                                }
                                case OSD_HEALTH_RESULT_WARNING: {
                                    dump.append("<font color=#FFFF00>warning (" + osdHealthCheckOutput + ")</font>");
                                    break;
                                }
                                case OSD_HEALTH_RESULT_NOT_AVAIL: {
                                    dump.append("Not available (" + (String)entry.getValue() + ")");
                                }
                            }
                        }
                    }
                    dump.append("</b></td></tr>");
                }
                dump.append("<tr><td width=\"30%\">");
                dump.append("last updated");
                dump.append("</td><td><b>");
                dump.append(sreg.getLast_updated_s());
                if (sreg.getLast_updated_s() == 0L) {
                    dump.append(" (service was shutdown)");
                } else {
                    long l;
                    dump.append(" (");
                    Date lastUpdatedDate = new Date(sreg.getLast_updated_s() * 1000L);
                    dump.append(lastUpdatedDate);
                    if ((sreg.getType() == DIR.ServiceType.SERVICE_TYPE_MRC || sreg.getType() == DIR.ServiceType.SERVICE_TYPE_OSD) && (l = lastUpdatedDate.getTime()) < System.currentTimeMillis() - 600000L) {
                        dump.append(", that's ");
                        dump.append(OutputUtils.SecondsToString((System.currentTimeMillis() - l) / 1000L));
                        dump.append(" ago. Please check connectivity of the server");
                    }
                    dump.append(")");
                    dump.append("</b></td></tr>");
                }
                dump.append("<td></td><td class=\"version\">version: <b>");
                dump.append(sreg.getVersion());
                dump.append("</b></td></table></td></tr>");
            }
            dump.append("</td></tr></table>");
            servRegIter.free();
            confIter = (ResultSet)database.prefixLookup(2, new byte[0], null).get();
            dump.append("<br><table width=\"100%\" frame=\"box\"><td colspan=\"2\" class=\"heading\">Configurations</td>");
            dump.append("<tr><td class=\"dumpTitle\">UUID</td><td class=\"dumpTitle\">Configuration Parameter</td></tr>");
            while (confIter.hasNext()) {
                e = (Map.Entry)confIter.next();
                uuid = new String((byte[])e.getKey());
                ConfigurationRecord conf = new ConfigurationRecord(ReusableBuffer.wrap((byte[])e.getValue()));
                dump.append("<tr><td class=\"uuid\">");
                dump.append(uuid);
                dump.append("</td><td class=\"dump\"><table width=\"100%\">");
                Collections.sort(conf.getData(), new Comparator<GlobalTypes.KeyValuePair>(){

                    @Override
                    public int compare(GlobalTypes.KeyValuePair o1, GlobalTypes.KeyValuePair o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                for (GlobalTypes.KeyValuePair kvp : conf.getData()) {
                    dump.append("<tr><td width=\"30%\">");
                    dump.append(kvp.getKey());
                    dump.append("</td><td><b>");
                    dump.append(kvp.getKey().equals(ServiceConfig.Parameter.ADMIN_PASSWORD.getPropertyString()) || kvp.getKey().equals(ServiceConfig.Parameter.CAPABILITY_SECRET.getPropertyString()) || kvp.getKey().equals(ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE.getPropertyString()) || kvp.getKey().equals(ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE.getPropertyString()) ? "*******" : kvp.getValue());
                    dump.append("</b></td></tr>");
                }
                dump.append("<td></td><td class=\"version\">version: <b>");
                dump.append(conf.getVersion());
                dump.append("</b></td></table></td></tr>");
            }
            confIter.free();
            dump.append("</b></td></table></td></tr>");
            dump.append("</table>");
            String tmp = null;
            try {
                tmp = this.statusPageTemplate.replace(Vars.AVAILPROCS.toString(), Runtime.getRuntime().availableProcessors() + " bytes");
            }
            catch (Exception e2) {
                tmp = this.statusPageTemplate;
            }
            tmp = tmp.replace(Vars.FREEMEM.toString(), Runtime.getRuntime().freeMemory() + " bytes");
            tmp = tmp.replace(Vars.MAXMEM.toString(), Runtime.getRuntime().maxMemory() + " bytes");
            tmp = tmp.replace(Vars.BPSTATS.toString(), BufferPool.getStatus());
            tmp = tmp.replace(Vars.PORT.toString(), Integer.toString(this.config.getPort()));
            tmp = tmp.replace(Vars.DEBUG.toString(), Integer.toString(this.config.getDebugLevel()));
            tmp = tmp.replace(Vars.NUMCON.toString(), Integer.toString(this.master.getNumConnections()));
            tmp = tmp.replace(Vars.NUMREQS.toString(), Long.toString(this.master.getNumRequests()));
            tmp = tmp.replace(Vars.TIME.toString(), new Date(time).toString() + " (" + time + ")");
            tmp = tmp.replace(Vars.TABLEDUMP.toString(), dump.toString());
            tmp = tmp.replace(Vars.VERSION.toString(), "1.5.0-master");
            tmp = tmp.replace(Vars.PROTOVERSION.toString(), Integer.toString(10001));
            tmp = tmp.replace(Vars.DBVERSION.toString(), "0.5.6");
            this.sendResponse(httpExchange, tmp);
        }
        catch (BabuDBException ex) {
            Logging.logError(4, null, ex);
            httpExchange.sendResponseHeaders(500, 0L);
        }
        finally {
            httpExchange.close();
            if (addrMapsIter != null) {
                addrMapsIter.free();
            }
            if (servRegIter != null) {
                servRegIter.free();
            }
            if (confIter != null) {
                confIter.free();
            }
        }
    }

    private static enum Vars {
        MAXMEM("<!-- $MAXMEM -->"),
        FREEMEM("<!-- $FREEMEM -->"),
        AVAILPROCS("<!-- $AVAILPROCS -->"),
        BPSTATS("<!-- $BPSTATS -->"),
        PORT("<!-- $PORT -->"),
        DEBUG("<!-- $DEBUG -->"),
        NUMCON("<!-- $NUMCON -->"),
        PINKYQ("<!-- $PINKYQ -->"),
        NUMREQS("<!-- $NUMREQS -->"),
        TIME("<!-- $TIME -->"),
        TABLEDUMP("<!-- $TABLEDUMP -->"),
        PROTOVERSION("<!-- $PROTOVERSION -->"),
        VERSION("<!-- $VERSION -->"),
        DBVERSION("<!-- $DBVERSION -->");

        private String template;

        private Vars(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

