/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class VivaldiClientMap
extends ConcurrentHashMap<String, VivaldiClientValue> {
    private static final long serialVersionUID = 1L;
    private final int MAX_SIZE;
    private final long TIME_OUT_IN_MS;

    public VivaldiClientMap(int maxSize, long timeOutInMS) {
        super(maxSize + 1);
        this.MAX_SIZE = maxSize;
        this.TIME_OUT_IN_MS = timeOutInMS;
    }

    @Override
    public void put(InetSocketAddress addr, GlobalTypes.VivaldiCoordinates coords) {
        if (this.MAX_SIZE > 0) {
            this.put(addr.getHostName(), new VivaldiClientValue(addr, coords));
            if (this.size() > this.MAX_SIZE) {
                this.filterTimeOuts();
                if (this.size() > this.MAX_SIZE) {
                    this.removeOldestEntry();
                }
            }
        }
    }

    private void removeOldestEntry() {
        long minTime = Long.MAX_VALUE;
        String minKey = null;
        boolean first = true;
        for (Map.Entry e : this.entrySet()) {
            long putTime = ((VivaldiClientValue)e.getValue()).getTimeStamp();
            if (!first && minTime >= putTime) continue;
            minTime = putTime;
            minKey = (String)e.getKey();
            first = false;
        }
        if (minKey != null) {
            this.remove(minKey);
        }
    }

    public void filterTimeOuts() {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            long timeSinceLastUpdate = System.currentTimeMillis() - ((VivaldiClientValue)it.next().getValue()).getTimeStamp();
            if (timeSinceLastUpdate <= this.TIME_OUT_IN_MS) continue;
            it.remove();
        }
    }

    public class VivaldiClientValue {
        private InetSocketAddress address;
        private GlobalTypes.VivaldiCoordinates coordinates;
        private long timeStamp;

        public VivaldiClientValue(InetSocketAddress addr, GlobalTypes.VivaldiCoordinates coords, long time) {
            this.address = addr;
            this.coordinates = coords;
            this.timeStamp = time;
        }

        public VivaldiClientValue(InetSocketAddress addr, GlobalTypes.VivaldiCoordinates coords) {
            this.address = addr;
            this.coordinates = coords;
            this.timeStamp = System.currentTimeMillis();
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public GlobalTypes.VivaldiCoordinates getCoordinates() {
            return this.coordinates;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

