/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.common.statusserver.StatusServerHelper;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.dir.DIRConfig;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.VivaldiClientMap;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class VivaldiStatusPage
extends StatusServerModule {
    private DIRRequestDispatcher master;
    private DIRConfig config;

    public VivaldiStatusPage(DIRConfig config) {
        this.config = config;
    }

    @Override
    public String getDisplayName() {
        return "Vivaldi Status Summary";
    }

    @Override
    public String getUriPath() {
        return "/vivaldi";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_DIR;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_DIR);
        this.master = (DIRRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String uriPath = httpExchange.getRequestURI().getPath();
        if (uriPath.equals("/vivaldi/data")) {
            try {
                String content = this.getVivaldiData();
                this.sendResponse(httpExchange, content);
            }
            catch (BabuDBException ex) {
                Logging.logError(4, null, ex);
                httpExchange.sendResponseHeaders(500, 0L);
            }
            finally {
                httpExchange.close();
            }
        } else if (uriPath.equals("/vivaldi")) {
            StatusServerHelper.sendFile("org/xtreemfs/dir/templates/vivaldi.html", httpExchange);
        } else if (uriPath.equals("/vivaldi/d3.js")) {
            StatusServerHelper.sendFile("org/xtreemfs/dir/templates/d3.js", httpExchange);
        } else {
            httpExchange.sendResponseHeaders(404, -1L);
            httpExchange.close();
        }
    }

    private String getVivaldiData() throws BabuDBException, IOException {
        Database database = this.master.getDirDatabase();
        StringBuilder dump = new StringBuilder();
        ResultSet iter = (ResultSet)database.prefixLookup(1, new byte[0], null).get();
        dump.append("uuid");
        dump.append("\t");
        dump.append("name");
        dump.append("\t");
        dump.append("type");
        dump.append("\t");
        dump.append("status");
        dump.append("\t");
        dump.append("vivaldi_x");
        dump.append("\t");
        dump.append("vivaldi_y");
        dump.append("\t");
        dump.append("vivaldi_err");
        while (iter.hasNext()) {
            GlobalTypes.VivaldiCoordinates coords;
            Map.Entry e = (Map.Entry)iter.next();
            String uuid = new String((byte[])e.getKey());
            ServiceRecord sreg = new ServiceRecord(ReusableBuffer.wrap((byte[])e.getValue()));
            DIR.ServiceStatus status = DIR.ServiceStatus.valueOf(Integer.valueOf(sreg.getData().get("static.status")));
            String statusString = "unknown value";
            switch (status) {
                case SERVICE_STATUS_AVAIL: {
                    statusString = "online";
                    break;
                }
                case SERVICE_STATUS_TO_BE_REMOVED: {
                    statusString = "locked";
                    break;
                }
                case SERVICE_STATUS_REMOVED: {
                    statusString = "removed";
                }
            }
            if (sreg.getType() == DIR.ServiceType.SERVICE_TYPE_OSD) {
                coords = VivaldiNode.stringToCoordinates(sreg.getData().get("vivaldi_coordinates"));
            } else {
                GlobalTypes.VivaldiCoordinates.Builder coordBuilder = GlobalTypes.VivaldiCoordinates.newBuilder();
                coordBuilder.setXCoordinate(0.0);
                coordBuilder.setYCoordinate(0.0);
                coordBuilder.setLocalError(0.0);
                coords = coordBuilder.build();
            }
            dump.append("\n");
            dump.append(uuid);
            dump.append("\t");
            dump.append(sreg.getName());
            dump.append("\t");
            dump.append(sreg.getType());
            dump.append("\t");
            dump.append(statusString);
            dump.append("\t");
            dump.append(coords.getXCoordinate());
            dump.append("\t");
            dump.append(coords.getYCoordinate());
            dump.append("\t");
            dump.append(coords.getLocalError());
        }
        iter.free();
        this.master.getVivaldiClientMap().filterTimeOuts();
        for (Map.Entry entry : this.master.getVivaldiClientMap().entrySet()) {
            dump.append("\n");
            dump.append(((VivaldiClientMap.VivaldiClientValue)entry.getValue()).getAddress().toString());
            dump.append("\t");
            dump.append(((VivaldiClientMap.VivaldiClientValue)entry.getValue()).getAddress().getHostName());
            dump.append("\t");
            dump.append("CLIENT");
            dump.append("\t");
            dump.append("online");
            dump.append("\t");
            dump.append(((VivaldiClientMap.VivaldiClientValue)entry.getValue()).getCoordinates().getXCoordinate());
            dump.append("\t");
            dump.append(((VivaldiClientMap.VivaldiClientValue)entry.getValue()).getCoordinates().getYCoordinate());
            dump.append("\t");
            dump.append(((VivaldiClientMap.VivaldiClientValue)entry.getValue()).getCoordinates().getLocalError());
        }
        return dump.toString();
    }
}

