/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.data;

import java.io.IOException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class AddressMappingRecord {
    public static final byte CURRENT_VERSION = 1;
    private String uuid;
    private long version;
    private String protocol;
    private String address;
    private int port;
    private String match_network;
    private int ttl_s;
    private String uri;

    public AddressMappingRecord(DIR.AddressMapping m) {
        this.uuid = m.getUuid();
        this.version = m.getVersion();
        this.protocol = m.getProtocol();
        this.address = m.getAddress();
        this.port = m.getPort();
        this.match_network = m.getMatchNetwork();
        this.ttl_s = m.getTtlS();
        this.uri = m.getUri();
    }

    public AddressMappingRecord(ReusableBuffer rb) throws IOException {
        byte recVersion = rb.get();
        if (recVersion != 1) {
            throw new IOException("don't know how to handle version " + recVersion);
        }
        this.uuid = rb.getString();
        this.version = rb.getLong();
        this.protocol = rb.getString();
        this.address = rb.getString();
        this.port = rb.getInt();
        this.match_network = rb.getString();
        this.ttl_s = rb.getInt();
        this.uri = rb.getString();
    }

    public int getSize() {
        int INT_SIZE = 4;
        int LONG_SIZE = 8;
        boolean BYTE_SIZE = true;
        return 36 + this.getUuid().length() + this.getProtocol().length() + this.getAddress().length() + this.getMatch_network().length() + this.getUri().length() + 1;
    }

    public void serialize(ReusableBuffer rb) {
        rb.put((byte)1);
        rb.putString(this.getUuid());
        rb.putLong(this.getVersion());
        rb.putString(this.getProtocol());
        rb.putString(this.getAddress());
        rb.putInt(this.getPort());
        rb.putString(this.getMatch_network());
        rb.putInt(this.getTtl_s());
        rb.putString(this.getUri());
    }

    public DIR.AddressMapping getAddressMapping() {
        DIR.AddressMapping m = DIR.AddressMapping.newBuilder().setUuid(this.uuid).setVersion(this.version).setProtocol(this.protocol).setAddress(this.address).setPort(this.port).setMatchNetwork(this.match_network).setTtlS(this.ttl_s).setUri(this.uri).build();
        return m;
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getVersion() {
        return this.version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getMatch_network() {
        return this.match_network;
    }

    public int getTtl_s() {
        return this.ttl_s;
    }

    public String getUri() {
        return this.uri;
    }
}

