/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.data;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.dir.data.AddressMappingRecord;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class AddressMappingRecords {
    ArrayList<AddressMappingRecord> records;

    public AddressMappingRecords() {
        this.records = new ArrayList(2);
    }

    public AddressMappingRecords(ReusableBuffer rb) throws IOException {
        try {
            int numEntries = rb.getInt();
            this.records = new ArrayList(numEntries);
            for (int i = 0; i < numEntries; ++i) {
                AddressMappingRecord m = new AddressMappingRecord(rb);
                this.records.add(m);
            }
        }
        catch (BufferUnderflowException ex) {
            throw new IOException("corrupted AddressMappingRecords entry: " + ex, ex);
        }
    }

    public AddressMappingRecords(DIR.AddressMappingSet set) {
        this.records = new ArrayList(set.getMappingsCount());
        for (DIR.AddressMapping am : set.getMappingsList()) {
            this.records.add(new AddressMappingRecord(am));
        }
    }

    public DIR.AddressMappingSet getAddressMappingSet() {
        DIR.AddressMappingSet.Builder set = DIR.AddressMappingSet.newBuilder();
        for (AddressMappingRecord rec : this.records) {
            set.addMappings(rec.getAddressMapping());
        }
        return set.build();
    }

    public void add(AddressMappingRecords otherList) {
        this.records.addAll(otherList.records);
    }

    public int size() {
        return this.records.size();
    }

    public AddressMappingRecord getRecord(int index) {
        return this.records.get(index);
    }

    public List<AddressMappingRecord> getRecords() {
        return this.records;
    }

    public int getSize() {
        int INT_SIZE = 4;
        int size = 4;
        for (AddressMappingRecord rec : this.records) {
            size += rec.getSize();
        }
        return size;
    }

    public void serialize(ReusableBuffer rb) throws IOException {
        try {
            rb.putInt(this.records.size());
            for (AddressMappingRecord rec : this.records) {
                rec.serialize(rb);
            }
        }
        catch (BufferOverflowException ex) {
            throw new IOException("buffer too small", ex);
        }
    }
}

