/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.data;

import java.io.IOException;
import java.util.Vector;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class ConfigurationRecord {
    public static final byte CURRENT_VERSION = 1;
    private String uuid;
    private long version;
    private Vector<GlobalTypes.KeyValuePair> configurationParameter;

    public ConfigurationRecord(DIR.Configuration c) {
        this.uuid = c.getUuid();
        this.version = c.getVersion();
        this.configurationParameter = new Vector();
        for (GlobalTypes.KeyValuePair kvp : c.getParameterList()) {
            this.configurationParameter.add(kvp);
        }
    }

    public ConfigurationRecord(ReusableBuffer rb) throws IOException {
        byte recVersion = rb.get();
        if (recVersion == 1) {
            this.uuid = rb.getString();
            this.version = rb.getLong();
            this.configurationParameter = new Vector();
            while (rb.remaining() != 0) {
                this.configurationParameter.add(GlobalTypes.KeyValuePair.newBuilder().setKey(rb.getString()).setValue(rb.getString()).build());
            }
        } else {
            throw new IOException("don't know how to handle version " + recVersion);
        }
    }

    public void serialize(ReusableBuffer rb) {
        rb.put((byte)1);
        rb.putString(this.uuid);
        rb.putLong(this.getVersion());
        for (GlobalTypes.KeyValuePair kvp : this.configurationParameter) {
            rb.putString(kvp.getKey());
            rb.putString(kvp.getValue());
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public DIR.Configuration getConfiguration() {
        DIR.Configuration.Builder conf = DIR.Configuration.newBuilder();
        conf.setUuid(this.getUuid()).setVersion(this.getVersion());
        for (GlobalTypes.KeyValuePair kvp : this.configurationParameter) {
            conf.addParameter(kvp);
        }
        return conf.build();
    }

    public int getSize() {
        boolean BYTE_SIZE = true;
        int INT_SIZE = 4;
        int LONG_SIZE = 8;
        int size = this.getUuid().length() + 4;
        size += 8;
        ++size;
        size += this.getData().size() * 4 * 2;
        for (GlobalTypes.KeyValuePair kvp : this.configurationParameter) {
            size += kvp.getKey().length() + kvp.getValue().length();
        }
        return size;
    }

    public Vector<GlobalTypes.KeyValuePair> getData() {
        return this.configurationParameter;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }
}

