/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class ServiceRecord {
    public static final byte CURRENT_VERSION = 1;
    private DIR.ServiceType type;
    private String uuid;
    private long version;
    private String name;
    private long last_updated_s;
    private Map<String, String> data;

    public ServiceRecord(DIR.Service service) {
        this.type = service.getType();
        this.uuid = service.getUuid();
        this.version = service.getVersion();
        this.name = service.getName();
        this.last_updated_s = service.getLastUpdatedS();
        this.data = new HashMap<String, String>();
        for (GlobalTypes.KeyValuePair kvp : service.getData().getDataList()) {
            this.data.put(kvp.getKey(), kvp.getValue());
        }
    }

    public ServiceRecord(ReusableBuffer rb) throws IOException {
        byte recVersion = rb.get();
        if (recVersion == 1) {
            this.type = DIR.ServiceType.valueOf(rb.getInt());
            this.uuid = rb.getString();
            this.version = rb.getLong();
            this.name = rb.getString();
            this.last_updated_s = rb.getLong();
            int numEntries = rb.getInt();
            this.data = new HashMap<String, String>();
            for (int i = 0; i < numEntries; ++i) {
                String key = rb.getString();
                String value = rb.getString();
                this.data.put(key, value);
            }
        } else {
            throw new IOException("don't know how to handle version " + recVersion);
        }
    }

    public DIR.Service getService() {
        DIR.Service.Builder s = DIR.Service.newBuilder();
        s.setType(this.type);
        s.setUuid(this.uuid);
        s.setVersion(this.version);
        s.setName(this.name);
        s.setLastUpdatedS(this.last_updated_s);
        DIR.ServiceDataMap.Builder sm = DIR.ServiceDataMap.newBuilder();
        for (Map.Entry<String, String> e : this.data.entrySet()) {
            GlobalTypes.KeyValuePair kvp = GlobalTypes.KeyValuePair.newBuilder().setKey(e.getKey()).setValue(e.getValue()).build();
            sm.addData(kvp);
        }
        s.setData(sm);
        return s.build();
    }

    public int getSize() {
        int INT_SIZE = 4;
        int LONG_SIZE = 8;
        boolean BYTE_SIZE = true;
        int size = 17 + this.getData().size() * 4 * 2 + 16 + this.getUuid().length() + this.getName().length();
        for (Map.Entry<String, String> e : this.getData().entrySet()) {
            size += e.getKey().length() + e.getValue().length();
        }
        return size;
    }

    public void serialize(ReusableBuffer rb) {
        rb.put((byte)1);
        rb.putInt(this.getType().getNumber());
        rb.putString(this.getUuid());
        rb.putLong(this.getVersion());
        rb.putString(this.getName());
        rb.putLong(this.getLast_updated_s());
        rb.putInt(this.getData().size());
        for (Map.Entry<String, String> e : this.getData().entrySet()) {
            rb.putString(e.getKey());
            rb.putString(e.getValue());
        }
    }

    public DIR.ServiceType getType() {
        return this.type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public long getLast_updated_s() {
        return this.last_updated_s;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setType(DIR.ServiceType type) {
        this.type = type;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLast_updated_s(long last_updated_s) {
        this.last_updated_s = last_updated_s;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }
}

