/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.data;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class ServiceRecords {
    ArrayList<ServiceRecord> records;

    public ServiceRecords() {
        this.records = new ArrayList(1);
    }

    public ServiceRecords(ReusableBuffer rb) throws IOException {
        try {
            int numEntries = rb.getInt();
            this.records = new ArrayList(numEntries);
            for (int i = 0; i < numEntries; ++i) {
                ServiceRecord m = new ServiceRecord(rb);
                this.records.add(m);
            }
        }
        catch (BufferUnderflowException ex) {
            throw new IOException("corrupted ServiceRecords entry: " + ex, ex);
        }
    }

    public ServiceRecords(DIR.ServiceSet set) {
        this.records = new ArrayList(set.getServicesCount());
        for (DIR.Service serv : set.getServicesList()) {
            this.records.add(new ServiceRecord(serv));
        }
    }

    public DIR.ServiceSet getServiceSet() {
        DIR.ServiceSet.Builder set = DIR.ServiceSet.newBuilder();
        for (ServiceRecord rec : this.records) {
            set.addServices(rec.getService());
        }
        return set.build();
    }

    public void add(ServiceRecords otherList) {
        this.records.addAll(otherList.records);
    }

    public void add(ServiceRecord item) {
        this.records.add(item);
    }

    public int size() {
        return this.records.size();
    }

    public ServiceRecord getRecord(int index) {
        return this.records.get(index);
    }

    public List<ServiceRecord> getList() {
        return this.records;
    }

    public int getSize() {
        int INT_SIZE = 4;
        int size = 4;
        for (ServiceRecord rec : this.records) {
            size += rec.getSize();
        }
        return size;
    }

    public void serialize(ReusableBuffer rb) throws IOException {
        try {
            rb.putInt(this.records.size());
            for (ServiceRecord rec : this.records) {
                rec.serialize(rb);
            }
        }
        catch (BufferOverflowException ex) {
            throw new IOException("buffer too small", ex);
        }
    }
}

