/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.discovery;

import com.google.protobuf.Message;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.PBRPCDatagramPacket;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class DiscoveryMsgThread
extends LifeCycleThread {
    private final DIR.DirService me;
    private boolean quit;

    public DiscoveryMsgThread(String address, int port, String protocol) {
        super("DiscovMsgThr");
        this.me = DIR.DirService.newBuilder().setAddress(address).setPort(port).setProtocol(protocol).setInterfaceVersion(10001).build();
        this.quit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        this.notifyStarted();
        ReusableBuffer data = BufferPool.allocate(2048);
        try {
            DatagramChannel channel = DatagramChannel.open();
            channel.socket().bind(new InetSocketAddress(this.me.getPort()));
            channel.configureBlocking(true);
            Logging.logMessage(6, Logging.Category.lifecycle, this.me, "DiscoveryMessageThread started", new Object[0]);
            do {
                data.position(0);
                data.limit(data.capacity());
                ReusableBuffer dataOut = null;
                try {
                    InetSocketAddress sender = (InetSocketAddress)channel.receive(data.getBuffer());
                    data.flip();
                    PBRPCDatagramPacket packetIn = new PBRPCDatagramPacket(data, (Message)Common.emptyRequest.getDefaultInstance());
                    RPC.RPCHeader resp = RPC.RPCHeader.newBuilder().setMessageType(RPC.MessageType.RPC_RESPONSE_SUCCESS).setCallId(packetIn.getHeader().getCallId()).build();
                    PBRPCDatagramPacket packetOut = new PBRPCDatagramPacket(resp, (Message)this.me);
                    dataOut = packetOut.assembleDatagramPacket();
                    channel.send(dataOut.getBuffer(), sender);
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.net, this, "responded to UDP dir discover message from %s", sender);
                    }
                    if (dataOut == null) continue;
                }
                catch (Exception ex) {
                    if (dataOut == null) continue;
                    BufferPool.free(dataOut);
                    continue;
                    catch (Throwable throwable) {
                        if (dataOut != null) {
                            BufferPool.free(dataOut);
                        }
                        throw throwable;
                    }
                }
                BufferPool.free(dataOut);
            } while (!this.quit);
            channel.close();
        }
        catch (Throwable ex) {
            if (!this.quit) {
                this.notifyCrashed(ex);
            }
        }
        finally {
            BufferPool.free(data);
        }
        this.notifyStopped();
        Logging.logMessage(6, Logging.Category.lifecycle, this.me, "DiscoveryMessageThread shutdown complete", new Object[0]);
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }
}

