/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.discovery;

import com.google.protobuf.Message;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.LinkedList;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.PBRPCDatagramPacket;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class DiscoveryUtils {
    public static final String AUTODISCOVER_HOSTNAME = ".autodiscover";

    public static DIR.DirService discoverDir(int maxWaitSeconds) {
        try {
            DatagramSocket dsock = new DatagramSocket();
            dsock.setBroadcast(true);
            dsock.setSoTimeout(1000);
            byte[] data = new byte[2048];
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> broadcasts = new LinkedList<InetAddress>();
            broadcasts.add(InetAddress.getLocalHost());
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                for (InterfaceAddress ia : nif.getInterfaceAddresses()) {
                    InetAddress bc = ia.getBroadcast();
                    if (bc == null) continue;
                    broadcasts.add(bc);
                }
            }
            for (int i = 0; i < maxWaitSeconds; ++i) {
                RPC.RPCHeader resp = RPC.RPCHeader.newBuilder().setMessageType(RPC.MessageType.RPC_REQUEST).setCallId(1).build();
                PBRPCDatagramPacket dpack = new PBRPCDatagramPacket(resp, (Message)Common.emptyRequest.getDefaultInstance());
                ReusableBuffer buf = dpack.assembleDatagramPacket();
                byte[] rdata = buf.getData();
                BufferPool.free(buf);
                for (InetAddress bc : broadcasts) {
                    DatagramPacket rp = new DatagramPacket(rdata, rdata.length, bc, GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber());
                    dsock.send(rp);
                }
                DatagramPacket p = new DatagramPacket(data, data.length);
                try {
                    dsock.receive(p);
                }
                catch (SocketTimeoutException ex) {
                    continue;
                }
                ReusableBuffer b = ReusableBuffer.wrap(data, 0, p.getLength());
                dpack = new PBRPCDatagramPacket(b, (Message)DIR.DirService.getDefaultInstance());
                DIR.DirService service = (DIR.DirService)dpack.getMessage();
                return service;
            }
            dsock.close();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

