/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public abstract class DIROperation {
    protected final DIRRequestDispatcher master;

    public DIROperation(DIRRequestDispatcher master) {
        this.master = master;
    }

    public abstract int getProcedureId();

    public abstract void startRequest(DIRRequest var1);

    public abstract boolean isAuthRequired();

    protected abstract Message getRequestMessagePrototype();

    public void parseRPCMessage(DIRRequest rq) throws IOException {
        rq.deserializeMessage(this.getRequestMessagePrototype());
    }

    void requestFailed(BabuDBException error, DIRRequest rq) {
        assert (error != null);
        rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, error.toString());
    }

    abstract void requestFinished(Object var1, DIRRequest var2);

    abstract class DBRequestListener<I, O>
    implements DatabaseRequestListener<I> {
        private final boolean finishRequest;

        DBRequestListener(boolean finishRequest) {
            this.finishRequest = finishRequest;
        }

        abstract O execute(I var1, DIRRequest var2) throws Exception;

        public void failed(BabuDBException error, Object request) {
            DIROperation.this.requestFailed(error, (DIRRequest)request);
        }

        public void finished(I data, Object context) {
            try {
                O result = this.execute(data, (DIRRequest)context);
                if (this.finishRequest) {
                    DIROperation.this.requestFinished(result, (DIRRequest)context);
                }
            }
            catch (IllegalArgumentException ex) {
                DIRRequest rq = (DIRRequest)context;
                rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
            }
            catch (ConcurrentModificationException ex) {
                DIRRequest rq = (DIRRequest)context;
                rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EAGAIN, ex.toString());
            }
            catch (Exception e) {
                DIRRequest rq = (DIRRequest)context;
                rq.sendInternalServerError(e);
            }
        }
    }
}

