/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseInsertGroup;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class DeregisterServiceOperation
extends DIROperation {
    private final Database database;

    public DeregisterServiceOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 6;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        DIR.serviceDeregisterRequest request = (DIR.serviceDeregisterRequest)rq.getRequestMessage();
        DatabaseInsertGroup ig = this.database.createInsertGroup();
        ig.addDelete(1, request.getUuid().getBytes());
        this.database.insert(ig, (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<Object, Object>(true){

            @Override
            Object execute(Object result, DIRRequest rq) throws Exception {
                return result;
            }
        });
        this.master.notifyServiceDeregistred(request.getUuid());
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.serviceDeregisterRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess(Common.emptyResponse.getDefaultInstance());
    }
}

