/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.AddressMappingRecords;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class GetAddressMappingOperation
extends DIROperation {
    private final Database database;

    public GetAddressMappingOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 1;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        DIR.addressMappingGetRequest request = (DIR.addressMappingGetRequest)rq.getRequestMessage();
        if (request.getUuid().length() > 0) {
            this.database.lookup(0, request.getUuid().getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], DIR.AddressMappingSet>(true){

                @Override
                DIR.AddressMappingSet execute(byte[] result, DIRRequest rq) throws Exception {
                    if (result == null) {
                        return DIR.AddressMappingSet.getDefaultInstance();
                    }
                    return new AddressMappingRecords(ReusableBuffer.wrap(result)).getAddressMappingSet();
                }
            });
        } else {
            this.database.prefixLookup(0, new byte[0], (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<ResultSet<byte[], byte[]>, DIR.AddressMappingSet>(true){

                @Override
                DIR.AddressMappingSet execute(ResultSet<byte[], byte[]> result, DIRRequest rq) throws Exception {
                    AddressMappingRecords list = new AddressMappingRecords();
                    while (result.hasNext()) {
                        Map.Entry e = (Map.Entry)result.next();
                        AddressMappingRecords recs = new AddressMappingRecords(ReusableBuffer.wrap((byte[])e.getValue()));
                        list.add(recs);
                    }
                    return list.getAddressMappingSet();
                }
            });
        }
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.addressMappingGetRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess((DIR.AddressMappingSet)result);
    }
}

