/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ConfigurationRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class GetConfigurationOperation
extends DIROperation {
    private final Database database;

    public GetConfigurationOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 22;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.configurationGetRequest.getDefaultInstance();
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess((DIR.Configuration)result);
    }

    @Override
    public void startRequest(DIRRequest rq) {
        DIR.configurationGetRequest request = (DIR.configurationGetRequest)rq.getRequestMessage();
        this.database.lookup(2, request.getUuid().getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], DIR.Configuration>(true){

            @Override
            DIR.Configuration execute(byte[] result, DIRRequest rq) throws Exception {
                if (result == null) {
                    return DIR.Configuration.getDefaultInstance();
                }
                return new ConfigurationRecord(ReusableBuffer.wrap(result)).getConfiguration();
            }
        });
    }
}

