/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class GetServiceByUuidOperation
extends DIROperation {
    private final Database database;

    public GetServiceByUuidOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 9;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        DIR.serviceGetByUUIDRequest request = (DIR.serviceGetByUUIDRequest)rq.getRequestMessage();
        this.database.lookup(1, request.getName().getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], DIR.ServiceSet>(true){

            @Override
            DIR.ServiceSet execute(byte[] result, DIRRequest rq) throws Exception {
                DIR.ServiceSet.Builder services = DIR.ServiceSet.newBuilder();
                if (result != null) {
                    ServiceRecord dbData = new ServiceRecord(ReusableBuffer.wrap(result));
                    services.addServices(dbData.getService());
                }
                return services.build();
            }
        });
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.serviceGetByUUIDRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess((DIR.ServiceSet)result);
    }
}

