/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class GetServicesByTypeOperation
extends DIROperation {
    private final Database database;

    public GetServicesByTypeOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 8;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        final DIR.serviceGetByTypeRequest request = (DIR.serviceGetByTypeRequest)rq.getRequestMessage();
        this.database.prefixLookup(1, new byte[0], (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<ResultSet<byte[], byte[]>, DIR.ServiceSet>(true){

            @Override
            DIR.ServiceSet execute(ResultSet<byte[], byte[]> result, DIRRequest rq) throws Exception {
                DIR.ServiceSet.Builder services = DIR.ServiceSet.newBuilder();
                long now = System.currentTimeMillis() / 1000L;
                while (result.hasNext()) {
                    Map.Entry e = (Map.Entry)result.next();
                    ServiceRecord servEntry = new ServiceRecord(ReusableBuffer.wrap((byte[])e.getValue()));
                    if (request.getType() != DIR.ServiceType.SERVICE_TYPE_MIXED && servEntry.getType() != request.getType()) continue;
                    long secondsSinceLastUpdate = now - servEntry.getLast_updated_s();
                    servEntry.getData().put("seconds_since_last_update", Long.toString(secondsSinceLastUpdate));
                    services.addServices(servEntry.getService());
                }
                return services.build();
            }
        });
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.serviceGetByTypeRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess((DIR.ServiceSet)result);
    }
}

