/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class RegisterServiceOperation
extends DIROperation {
    private final Database database;

    public RegisterServiceOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 11;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        final DIR.serviceRegisterRequest request = (DIR.serviceRegisterRequest)rq.getRequestMessage();
        final DIR.Service.Builder reg = request.getService().toBuilder();
        this.database.lookup(1, reg.getUuid().getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], Long>(false){

            @Override
            Long execute(byte[] result, DIRRequest rq) throws Exception {
                long currentVersion = 0L;
                ServiceRecord sRec = new ServiceRecord(request.getService().toBuilder().build());
                boolean doNotSetLastUpdated = Boolean.parseBoolean(sRec.getData().get("static.do_not_set_last_updated"));
                if (result != null) {
                    ReusableBuffer buf = ReusableBuffer.wrap(result);
                    ServiceRecord dbData = new ServiceRecord(buf);
                    currentVersion = dbData.getVersion();
                } else {
                    int protoVersion;
                    int load;
                    int status;
                    long usedRam;
                    long totalRam;
                    String uuid = sRec.getUuid();
                    String name = sRec.getName();
                    String type = sRec.getType().toString();
                    String pageUrl = sRec.getData().get("status_page_url") == null ? "" : sRec.getData().get("status_page_url");
                    String geoCoordinates = sRec.getData().get("vivaldi_coordinates") == null ? "" : sRec.getData().get("vivaldi_coordinates");
                    try {
                        totalRam = Long.parseLong(sRec.getData().get("totalRAM"));
                    }
                    catch (NumberFormatException nfe) {
                        totalRam = -1L;
                    }
                    try {
                        usedRam = Long.parseLong(sRec.getData().get("usedRAM"));
                    }
                    catch (NumberFormatException nfe) {
                        usedRam = -1L;
                    }
                    long lastUpdated = System.currentTimeMillis() / 1000L;
                    try {
                        status = Integer.parseInt(sRec.getData().get("static.status"));
                    }
                    catch (NumberFormatException nfe) {
                        status = -1;
                    }
                    try {
                        load = Integer.parseInt(sRec.getData().get("load"));
                    }
                    catch (NumberFormatException nfe) {
                        load = -1;
                    }
                    try {
                        protoVersion = Integer.parseInt(sRec.getData().get("proto_version"));
                    }
                    catch (NumberFormatException nfe) {
                        protoVersion = -1;
                    }
                    RegisterServiceOperation.this.master.notifyServiceRegistred(uuid, name, type, pageUrl, geoCoordinates, totalRam, usedRam, lastUpdated, status, load, protoVersion);
                }
                if (reg.getVersion() != currentVersion) {
                    throw new ConcurrentModificationException("The requested version number (" + reg.getVersion() + ") did not match the " + "expected version (" + currentVersion + ")!");
                }
                final long version = ++currentVersion;
                reg.setVersion(currentVersion);
                if (!doNotSetLastUpdated) {
                    reg.setLastUpdatedS(System.currentTimeMillis() / 1000L);
                }
                ServiceRecord newRec = new ServiceRecord(reg.build());
                Map<String, String> newRecData = newRec.getData();
                newRecData.remove("static.do_not_set_last_updated");
                newRec.setData(newRecData);
                byte[] newData = new byte[newRec.getSize()];
                newRec.serialize(ReusableBuffer.wrap(newData));
                RegisterServiceOperation.this.database.singleInsert(1, newRec.getUuid().getBytes(), newData, (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<Object, Long>(true){

                    @Override
                    Long execute(Object result, DIRRequest rq) throws Exception {
                        return version;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.serviceRegisterRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        DIR.serviceRegisterResponse resp = DIR.serviceRegisterResponse.newBuilder().setNewVersion((Long)result).build();
        rq.sendSuccess(resp);
    }
}

