/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ServiceRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class ServiceOfflineOperation
extends DIROperation {
    private final Database database;

    public ServiceOfflineOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 10;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        final DIR.serviceGetByUUIDRequest request = (DIR.serviceGetByUUIDRequest)rq.getRequestMessage();
        this.database.lookup(1, request.getName().getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], Object>(false){

            @Override
            Object execute(byte[] result, DIRRequest rq) throws Exception {
                if (result != null) {
                    ReusableBuffer buf = ReusableBuffer.wrap(result);
                    ServiceRecord dbData = new ServiceRecord(buf);
                    dbData.setLast_updated_s(0L);
                    dbData.setVersion(dbData.getVersion() + 1L);
                    byte[] newData = new byte[dbData.getSize()];
                    dbData.serialize(ReusableBuffer.wrap(newData));
                    ServiceOfflineOperation.this.database.singleInsert(1, request.getName().getBytes(), newData, (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<Object, Object>(true){

                        @Override
                        Object execute(Object result, DIRRequest rq) throws Exception {
                            return null;
                        }
                    });
                } else {
                    ServiceOfflineOperation.this.requestFinished(null, rq);
                }
                return null;
            }
        });
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.serviceGetByUUIDRequest.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        rq.sendSuccess(Common.emptyResponse.getDefaultInstance());
    }
}

