/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.util.ConcurrentModificationException;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.AddressMappingRecord;
import org.xtreemfs.dir.data.AddressMappingRecords;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class SetAddressMappingOperation
extends DIROperation {
    private final Database database;

    public SetAddressMappingOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 3;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        final DIR.AddressMappingSet mappings = (DIR.AddressMappingSet)rq.getRequestMessage();
        String uuid = null;
        if (mappings.getMappingsCount() == 0) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "non-empty address mapping set not allowed");
            return;
        }
        for (DIR.AddressMapping am : mappings.getMappingsList()) {
            if (uuid == null) {
                uuid = am.getUuid();
            }
            if (am.getUuid().equals(uuid)) continue;
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "all mappings must have the same UUID");
            return;
        }
        assert (uuid != null);
        assert (this.database != null);
        final String UUID = uuid;
        this.database.lookup(0, uuid.getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], Long>(false){

            @Override
            Long execute(byte[] result, DIRRequest rq) throws Exception {
                ReusableBuffer buf;
                AddressMappingRecords dbData;
                long currentVersion = 0L;
                if (result != null && (dbData = new AddressMappingRecords(buf = ReusableBuffer.wrap(result))).size() > 0) {
                    currentVersion = dbData.getRecord(0).getVersion();
                }
                if (mappings.getMappings(0).getVersion() != currentVersion) {
                    throw new ConcurrentModificationException();
                }
                final long version = ++currentVersion;
                DIR.AddressMappingSet.Builder newSet = mappings.toBuilder();
                for (int i = 0; i < mappings.getMappingsCount(); ++i) {
                    newSet.setMappings(i, mappings.getMappings(i).toBuilder().setVersion(currentVersion));
                }
                AddressMappingRecords newData = new AddressMappingRecords(newSet.build());
                int size = newData.getSize();
                byte[] newBytes = new byte[size];
                ReusableBuffer buf2 = ReusableBuffer.wrap(newBytes);
                newData.serialize(buf2);
                SetAddressMappingOperation.this.database.singleInsert(0, UUID.getBytes(), newBytes, (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<Object, Long>(true){

                    @Override
                    Long execute(Object result, DIRRequest rq) throws Exception {
                        return version;
                    }
                });
                for (AddressMappingRecord amr : newData.getRecords()) {
                    SetAddressMappingOperation.this.master.notifyAddressMappingAdded(amr.getUuid(), amr.getUri());
                }
                return null;
            }
        });
    }

    @Override
    public boolean isAuthRequired() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.AddressMappingSet.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        DIR.addressMappingSetResponse resp = DIR.addressMappingSetResponse.newBuilder().setNewVersion((Long)result).build();
        rq.sendSuccess(resp);
    }
}

