/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.util.ConcurrentModificationException;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.data.ConfigurationRecord;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class SetConfigurationOperation
extends DIROperation {
    private final Database database;

    public SetConfigurationOperation(DIRRequestDispatcher master) throws BabuDBException {
        super(master);
        this.database = master.getDirDatabase();
    }

    @Override
    public int getProcedureId() {
        return 23;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return DIR.Configuration.getDefaultInstance();
    }

    @Override
    public boolean isAuthRequired() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
        DIR.configurationSetResponse response = DIR.configurationSetResponse.newBuilder().setNewVersion((Long)result).build();
        rq.sendSuccess(response);
    }

    @Override
    public void startRequest(DIRRequest rq) {
        final DIR.Configuration conf = (DIR.Configuration)rq.getRequestMessage();
        String uuid = null;
        if (conf.getParameterCount() == 0) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "empty configuration set not allowed");
            return;
        }
        uuid = conf.getUuid();
        assert (uuid != null);
        assert (this.database != null);
        final String UUID = uuid;
        this.database.lookup(2, uuid.getBytes(), (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<byte[], Long>(false){

            @Override
            Long execute(byte[] result, DIRRequest rq) throws Exception {
                long currentVersion = 0L;
                if (result != null) {
                    ReusableBuffer buf = ReusableBuffer.wrap(result);
                    ConfigurationRecord dbData = new ConfigurationRecord(buf);
                    currentVersion = dbData.getVersion();
                }
                if (conf.getVersion() != currentVersion) {
                    throw new ConcurrentModificationException();
                }
                final long version = ++currentVersion;
                ConfigurationRecord newRec = new ConfigurationRecord(conf);
                newRec.setVersion(version);
                int size = newRec.getSize();
                byte[] newBytes = new byte[size];
                ReusableBuffer buf = ReusableBuffer.wrap(newBytes);
                newRec.serialize(buf);
                SetConfigurationOperation.this.database.singleInsert(2, UUID.getBytes(), newBytes, (Object)rq).registerListener((DatabaseRequestListener)new DIROperation.DBRequestListener<Object, Long>(true){

                    @Override
                    Long execute(Object result, DIRRequest rq) throws Exception {
                        return version;
                    }
                });
                return null;
            }
        });
    }
}

