/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.dir.operations;

import com.google.protobuf.Message;
import java.net.InetSocketAddress;
import org.xtreemfs.dir.DIRRequest;
import org.xtreemfs.dir.DIRRequestDispatcher;
import org.xtreemfs.dir.VivaldiClientMap;
import org.xtreemfs.dir.operations.DIROperation;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class UpdateVivaldiClientOperation
extends DIROperation {
    private VivaldiClientMap vivaldiClientMap;

    public UpdateVivaldiClientOperation(DIRRequestDispatcher master) {
        super(master);
        this.vivaldiClientMap = master.getVivaldiClientMap();
    }

    @Override
    public int getProcedureId() {
        return 24;
    }

    @Override
    public void startRequest(DIRRequest rq) {
        GlobalTypes.VivaldiCoordinates coords = (GlobalTypes.VivaldiCoordinates)rq.getRequestMessage();
        InetSocketAddress clientAddress = (InetSocketAddress)rq.getRPCRequest().getSenderAddress();
        this.vivaldiClientMap.put(clientAddress, coords);
        rq.sendSuccess(Common.emptyResponse.getDefaultInstance());
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    protected Message getRequestMessagePrototype() {
        return GlobalTypes.VivaldiCoordinates.getDefaultInstance();
    }

    @Override
    void requestFinished(Object result, DIRRequest rq) {
    }
}

