/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation;

import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.logging.Logging;

public class LifeCycleThread
extends Thread {
    private final Object startLock = new Object();
    private final Object stopLock = new Object();
    private boolean started;
    private boolean stopped;
    private Exception exc;
    private LifeCycleListener listener;

    public LifeCycleThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStarted() {
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, this, "Thread %s started", Thread.currentThread().getName());
        }
        Object object = this.startLock;
        synchronized (object) {
            this.started = true;
            this.startLock.notifyAll();
            if (this.listener != null) {
                this.listener.startupPerformed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStopped() {
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, this, "Thread %s terminated", Thread.currentThread().getName());
        }
        Object object = this.stopLock;
        synchronized (object) {
            this.stopped = true;
            this.stopLock.notifyAll();
            if (this.listener != null) {
                this.listener.shutdownPerformed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCrashed(Throwable exc) {
        Logging.logMessage(2, this, "service ***CRASHED***, shutting down", new Object[0]);
        Logging.logError(2, this, exc);
        Object object = this.startLock;
        synchronized (object) {
            this.exc = exc instanceof Exception ? (Exception)exc : new Exception(exc);
            this.started = true;
            this.startLock.notifyAll();
        }
        object = this.stopLock;
        synchronized (object) {
            this.exc = exc instanceof Exception ? (Exception)exc : new Exception(exc);
            this.stopped = true;
            this.stopLock.notifyAll();
        }
        if (this.listener != null) {
            this.listener.crashPerformed(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStartup() throws Exception {
        Object object = this.startLock;
        synchronized (object) {
            while (!this.started) {
                this.startLock.wait();
            }
            if (this.exc != null && this.listener == null) {
                throw this.exc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() throws Exception {
        Object object = this.stopLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            while (!this.stopped) {
                try {
                    this.stopLock.wait();
                }
                catch (InterruptedException e) {
                    if (this.listener != null) continue;
                    throw e;
                }
            }
            if (this.exc != null && this.listener == null) {
                throw this.exc;
            }
        }
    }

    public void shutdown() throws Exception {
    }

    public void setLifeCycleListener(LifeCycleListener listener) {
        this.listener = listener;
    }
}

