/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;

public class SSLOptions {
    public static final String JKS_CONTAINER = "JKS";
    public static final String PKCS12_CONTAINER = "PKCS12";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private final InputStream serverCredentialFile;
    private final InputStream trustedCertificatesFile;
    private final char[] serverCredentialFilePassphrase;
    private final char[] trustedCertificatesFilePassphrase;
    private boolean authenticationWithoutEncryption;
    private final String serverCredentialFileContainer;
    private final String trustedCertificatesFileContainer;
    private final SSLContext sslContext;
    private final boolean useFakeSSLMode;

    public SSLOptions(InputStream serverCredentialFile, String serverCredentialFilePassphrase, String serverCredentialFileContainer, InputStream trustedCertificatesFile, String trustedCertificatesFilePassphrase, String trustedCertificatesFileContainer, boolean authenticationWithoutEncryption, boolean useFakeSSLMode, String sslProtocolString, TrustManager trustManager) throws IOException {
        this.serverCredentialFile = serverCredentialFile;
        this.trustedCertificatesFile = trustedCertificatesFile;
        this.serverCredentialFilePassphrase = (char[])(serverCredentialFilePassphrase != null ? serverCredentialFilePassphrase.toCharArray() : null);
        this.trustedCertificatesFilePassphrase = (char[])(trustedCertificatesFilePassphrase != null ? trustedCertificatesFilePassphrase.toCharArray() : null);
        this.serverCredentialFileContainer = serverCredentialFileContainer;
        this.trustedCertificatesFileContainer = trustedCertificatesFileContainer;
        this.authenticationWithoutEncryption = authenticationWithoutEncryption;
        this.useFakeSSLMode = useFakeSSLMode;
        this.sslContext = this.createSSLContext(this.sslProtocolStringToProtocol(sslProtocolString), trustManager);
    }

    private SSLContext createSSLContext(String sslProtocol, TrustManager trustManager) throws IOException {
        SSLContext sslContext = null;
        try {
            KeyManagerFactory kmf;
            block24: {
                KeyStore ksKeys = KeyStore.getInstance(this.serverCredentialFileContainer);
                ksKeys.load(this.serverCredentialFile, this.serverCredentialFilePassphrase);
                kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ksKeys, this.serverCredentialFilePassphrase);
                if ("OpenJDK Runtime Environment".equals(System.getProperty("java.runtime.name"))) {
                    try {
                        Security.removeProvider("SunPKCS11-NSS");
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, this, "Successfully removed faulty security provider 'SunPKCS11-NSS'.", new Object[0]);
                        }
                    }
                    catch (SecurityException e) {
                        Logging.logMessage(4, this, "Could not remove security provider 'SunPKCS11-NSS'. This might cause TLS connections to time out. Known to affect multiple OpenJDK / NSS version combinations.", new Object[0]);
                        if (!Logging.isDebug()) break block24;
                        Logging.logMessage(7, this, "%s:\n%s", e.getMessage(), OutputUtils.stackTraceToString(e));
                    }
                }
            }
            String defaultDisabledAlgorithms = Security.getProperty("jdk.tls.disabledAlgorithms");
            this.removeDisabledEntailedProtocolSupportForProtocol(sslProtocol);
            try {
                sslContext = SSLContext.getInstance(sslProtocol);
            }
            catch (NoSuchAlgorithmException e) {
                block25: {
                    Logging.logMessage(4, this, "Unsupported algorithm '%s', defaulting to '%s'.", sslProtocol, DEFAULT_SSL_PROTOCOL);
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "%s:\n%s", e.getMessage(), OutputUtils.stackTraceToString(e));
                    }
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "Trying to reset disabled algorithms.", new Object[0]);
                    }
                    try {
                        Security.setProperty("jdk.tls.disabledAlgorithms", defaultDisabledAlgorithms);
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, this, "Successfully reset disabled algorithms.", new Object[0]);
                        }
                    }
                    catch (SecurityException e1) {
                        if (!Logging.isDebug()) break block25;
                        Logging.logMessage(7, this, "Could not reset disabled algorithms: %s", OutputUtils.stackTraceToString(e1));
                    }
                }
                this.removeDisabledEntailedProtocolSupportForProtocol(DEFAULT_SSL_PROTOCOL);
                sslContext = SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "Disabling the following algorithms: %s", Security.getProperty("jdk.tls.disabledAlgorithms"));
            }
            if (trustManager != null) {
                trustManager.init(this.trustedCertificatesFileContainer, this.trustedCertificatesFile, this.trustedCertificatesFilePassphrase);
                sslContext.init(kmf.getKeyManagers(), new TrustManager[]{trustManager}, null);
            } else if (this.trustedCertificatesFileContainer.equals("none")) {
                javax.net.ssl.TrustManager[] myTMs = new TrustManager[]{new NoAuthTrustStore()};
                sslContext.init(kmf.getKeyManagers(), myTMs, null);
            } else {
                KeyStore ksTrust = null;
                if (this.trustedCertificatesFileContainer.equals("none")) {
                    ksTrust = KeyStore.getInstance(KeyStore.getDefaultType());
                } else {
                    ksTrust = KeyStore.getInstance(this.trustedCertificatesFileContainer);
                    ksTrust.load(this.trustedCertificatesFile, this.trustedCertificatesFilePassphrase);
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ksTrust);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            }
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return sslContext;
    }

    public boolean isAuthenticationWithoutEncryption() {
        return this.authenticationWithoutEncryption;
    }

    public void setAuthenticationWithoutEncryption(boolean authenticationWithoutEncryption) {
        this.authenticationWithoutEncryption = authenticationWithoutEncryption;
    }

    public InputStream getServerCredentialFile() {
        return this.serverCredentialFile;
    }

    public String getServerCredentialFileContainer() {
        return this.serverCredentialFileContainer;
    }

    public String getServerCredentialFilePassphrase() {
        return this.serverCredentialFilePassphrase.toString();
    }

    public InputStream getTrustedCertificatesFile() {
        return this.trustedCertificatesFile;
    }

    public String getTrustedCertificatesFileContainer() {
        return this.trustedCertificatesFileContainer;
    }

    public String getTrustedCertificatesFilePassphrase() {
        return this.trustedCertificatesFilePassphrase.toString();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public boolean isFakeSSLMode() {
        return this.useFakeSSLMode;
    }

    public String getSSLProtocol() {
        return this.sslContext.getProtocol();
    }

    public boolean isSSLEngineProtocolSupported(String sslEngineProtocol) {
        String sslProtocol = this.getSSLProtocol();
        if ("SSLv3".equals(sslProtocol)) {
            return "SSLv3".equals(sslEngineProtocol);
        }
        if (DEFAULT_SSL_PROTOCOL.equals(sslProtocol)) {
            return "SSLv3".equals(sslEngineProtocol) || "TLSv1".equals(sslEngineProtocol) || "TLSv1.1".equals(sslEngineProtocol) || "TLSv1.2".equals(sslEngineProtocol);
        }
        if ("TLSv1".equals(sslProtocol)) {
            return "TLSv1".equals(sslEngineProtocol);
        }
        if ("TLSv1.1".equals(sslProtocol)) {
            return "TLSv1.1".equals(sslEngineProtocol);
        }
        if ("TLSv1.2".equals(sslProtocol)) {
            return "TLSv1.2".equals(sslEngineProtocol);
        }
        return false;
    }

    private String sslProtocolStringToProtocol(String sslProtocolString) {
        if ("sslv3".equals(sslProtocolString)) {
            return "SSLv3";
        }
        if ("ssltls".equals(sslProtocolString)) {
            return DEFAULT_SSL_PROTOCOL;
        }
        if ("tlsv1".equals(sslProtocolString)) {
            return "TLSv1";
        }
        if ("tlsv11".equals(sslProtocolString)) {
            return "TLSv1.1";
        }
        if ("tlsv12".equals(sslProtocolString)) {
            return "TLSv1.2";
        }
        if (sslProtocolString != null) {
            Logging.logMessage(4, Logging.Category.net, this, "Unknown SSL Context Protocol: '%s', defaulting to '%s'.", sslProtocolString, DEFAULT_SSL_PROTOCOL);
        }
        return DEFAULT_SSL_PROTOCOL;
    }

    private void removeDisabledEntailedProtocolSupportForProtocol(String sslProtocol) {
        if (Security.getProperty("jdk.tls.disabledAlgorithms") == null) {
            return;
        }
        String[] entailedSupportedProtocols = new String[]{};
        if ("SSLv3".equals(sslProtocol)) {
            entailedSupportedProtocols = new String[]{"SSLv3"};
        } else if (DEFAULT_SSL_PROTOCOL.equals(sslProtocol)) {
            entailedSupportedProtocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        } else if ("TLSv1".equals(sslProtocol)) {
            entailedSupportedProtocols = new String[]{"TLSv1"};
        } else if ("TLSv1.1".equals(sslProtocol)) {
            entailedSupportedProtocols = new String[]{"TLSv1.1"};
        } else if ("TLSv1.2".equals(sslProtocol)) {
            entailedSupportedProtocols = new String[]{"TLSv1.2"};
        }
        for (String supportedSSLProtocol : entailedSupportedProtocols) {
            if (!Security.getProperty("jdk.tls.disabledAlgorithms").contains(supportedSSLProtocol)) continue;
            Logging.logMessage(4, this, "Algorithm '%s' is disabled in your java.security configuration file (see key 'jdk.tls.disabledAlgorithms'). Trying to enable algorithm '%s' manually as specified in your configuration file (see key 'ssl.protocol'). Consider using a newer SSL/TLS algorithm for your setup, as algorithm '%s' has been disabled by default because of security issues.", supportedSSLProtocol, supportedSSLProtocol, supportedSSLProtocol);
            try {
                Security.setProperty("jdk.tls.disabledAlgorithms", Security.getProperty("jdk.tls.disabledAlgorithms").replace(supportedSSLProtocol, "").replace("  ", ""));
                if (!Logging.isDebug()) continue;
                Logging.logMessage(7, this, "Successfully removed algorithm '%s' from disabled algorithms.", supportedSSLProtocol);
            }
            catch (SecurityException e) {
                Logging.logMessage(4, this, "Could not remove algorithm '%s' from disabled algorithm. This might cause SSL Handshake exceptions. For SSLv3 this is known to affect all JDKs fixing issue CVE-2014-3566.", supportedSSLProtocol);
            }
        }
    }

    public static interface TrustManager
    extends javax.net.ssl.TrustManager {
        public void init(String var1, InputStream var2, char[] var3);
    }

    private static class NoAuthTrustStore
    implements TrustManager,
    X509TrustManager {
        private NoAuthTrustStore() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void init(String trustedCertificatesFileContainer, InputStream trustedCertificatesFile, char[] trustedCertificatesFilePassphrase) {
        }
    }
}

