/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.buffer;

import java.io.Serializable;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public final class ASCIIString
implements Serializable {
    private static final long serialVersionUID = 4633232360908659139L;
    private byte[] data;
    private int hash;

    protected ASCIIString() {
    }

    public ASCIIString(String str) {
        this.data = str.getBytes();
    }

    protected ASCIIString(byte[] data) {
        this.data = data;
    }

    public String toString() {
        return new String(this.data);
    }

    public char charAt(int index) {
        return (char)this.data[index];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            ASCIIString other = (ASCIIString)o;
            if (other.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == other.data[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public void marshall(ReusableBuffer target) {
        target.putInt(this.data.length);
        target.put(this.data);
    }

    public static ASCIIString unmarshall(ReusableBuffer target) {
        int length = target.getInt();
        if (length < 0) {
            return null;
        }
        byte[] tmp = new byte[length];
        target.get(tmp);
        return new ASCIIString(tmp);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.data.length; ++i) {
                h = 31 * h + this.data[i];
            }
            this.hash = h;
        }
        return h;
    }

    public int length() {
        return this.data.length;
    }

    public int getSerializedSize() {
        return this.length() + 4;
    }
}

