/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public final class BufferPool {
    public static final int[] BUFF_SIZES = new int[]{8192, 65536, 131072, 524288, 0x200000};
    public static final int[] MAX_POOL_SIZES = new int[]{2000, 200, 100, 10, 5};
    private final ConcurrentLinkedQueue<ByteBuffer>[] pools = new ConcurrentLinkedQueue[BUFF_SIZES.length];
    private final AtomicInteger[] poolSizes;
    private final AtomicLong[] requests;
    private final AtomicLong[] creates = new AtomicLong[BUFF_SIZES.length];
    private final AtomicLong[] deletes;
    private static final BufferPool instance = new BufferPool();
    protected static boolean recordStackTraces = false;

    private BufferPool() {
        int i;
        for (i = 0; i < this.creates.length; ++i) {
            this.creates[i] = new AtomicLong();
        }
        this.requests = new AtomicLong[BUFF_SIZES.length + 1];
        this.deletes = new AtomicLong[BUFF_SIZES.length + 1];
        for (i = 0; i < BUFF_SIZES.length + 1; ++i) {
            this.requests[i] = new AtomicLong();
            this.deletes[i] = new AtomicLong();
        }
        this.poolSizes = new AtomicInteger[BUFF_SIZES.length];
        for (i = 0; i < BUFF_SIZES.length; ++i) {
            this.pools[i] = new ConcurrentLinkedQueue();
            this.poolSizes[i] = new AtomicInteger(0);
        }
    }

    public static ReusableBuffer allocate(int size) {
        ReusableBuffer tmp = instance.getNewBuffer(size);
        assert (tmp.refCount.get() == 1) : "newly allocated buffer has invalid reference count: " + tmp.refCount.get();
        if (recordStackTraces) {
            tmp.allocStack = "\n";
            for (StackTraceElement elem : new Exception().getStackTrace()) {
                tmp.allocStack = tmp.allocStack + elem.toString() + "\n";
            }
        }
        return tmp;
    }

    public static void free(ReusableBuffer buf) {
        if (buf != null) {
            instance.returnBuffer(buf);
        }
    }

    private ReusableBuffer getNewBuffer(int size) {
        try {
            for (int i = 0; i < BUFF_SIZES.length; ++i) {
                if (size > BUFF_SIZES[i]) continue;
                ByteBuffer buf = this.pools[i].poll();
                if (buf == null) {
                    buf = this.creates[i].get() < (long)MAX_POOL_SIZES[i] ? ByteBuffer.allocateDirect(BUFF_SIZES[i]) : ByteBuffer.allocate(BUFF_SIZES[i]);
                    this.creates[i].incrementAndGet();
                } else {
                    this.poolSizes[i].decrementAndGet();
                }
                this.requests[i].incrementAndGet();
                return new ReusableBuffer(buf, size);
            }
            this.requests[BUFF_SIZES.length].incrementAndGet();
            ByteBuffer buf = ByteBuffer.allocate(size);
            return new ReusableBuffer(buf, size);
        }
        catch (OutOfMemoryError ex) {
            System.out.println(BufferPool.getStatus());
            throw ex;
        }
    }

    private void returnBuffer(ReusableBuffer buffer) {
        this.returnBuffer(buffer, false);
    }

    private void returnBuffer(ReusableBuffer buffer, boolean callFromView) {
        if (!buffer.isReusable()) {
            return;
        }
        if (buffer.viewParent != null) {
            if (recordStackTraces) {
                if (buffer.freeStack == null) {
                    buffer.freeStack = "";
                }
                buffer.freeStack = buffer.freeStack + "\n";
                StackTraceElement[] stackTrace = new Exception().getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    buffer.freeStack = buffer.freeStack + stackTrace[i].toString() + "\n";
                }
            }
            assert (!buffer.returned) : "buffer was already released: " + buffer.freeStack;
            buffer.returned = true;
            this.returnBuffer(buffer.viewParent, true);
        } else {
            int i;
            assert (!buffer.returned || callFromView) : "buffer was already released: " + buffer.freeStack;
            if (recordStackTraces) {
                if (buffer.freeStack == null) {
                    buffer.freeStack = "";
                }
                buffer.freeStack = buffer.freeStack + "\n";
                StackTraceElement[] stackTrace = new Exception().getStackTrace();
                for (i = 0; i < stackTrace.length; ++i) {
                    buffer.freeStack = buffer.freeStack + stackTrace[i].toString() + "\n";
                }
            }
            if (!callFromView) {
                buffer.returned = true;
            }
            if (buffer.refCount.getAndDecrement() > 1) {
                return;
            }
            ByteBuffer buf = buffer.getParent();
            buf.clear();
            for (i = 0; i < BUFF_SIZES.length; ++i) {
                if (buf.capacity() != BUFF_SIZES[i]) continue;
                if (buf.isDirect()) {
                    this.poolSizes[i].incrementAndGet();
                    this.pools[i].add(buf);
                    return;
                }
                this.deletes[i].incrementAndGet();
                return;
            }
            assert (!buf.isDirect()) : "encountered direct buffer that does not fit in any of the pools (size=" + buf.capacity() + "): " + buffer.freeStack;
            this.deletes[this.deletes.length - 1].incrementAndGet();
        }
    }

    public static int getPoolSize(int bufferSize) {
        for (int i = 0; i < BUFF_SIZES.length; ++i) {
            if (BUFF_SIZES[i] != bufferSize) continue;
            return BufferPool.instance.poolSizes[i].get();
        }
        throw new IllegalArgumentException("Specified buffer size is not pooled. Check BufferPool configuration.");
    }

    public static String getStatus() {
        String str = "";
        for (int i = 0; i < BUFF_SIZES.length; ++i) {
            str = str + String.format("%8d:      poolSize = %5d    numRequests = %8d    creates = %8d   deletes = %8d\n", BUFF_SIZES[i], BufferPool.instance.poolSizes[i].get(), BufferPool.instance.requests[i].get(), BufferPool.instance.creates[i].get(), BufferPool.instance.deletes[i].get());
        }
        str = str + String.format("unpooled (> %8d)    numRequests = creates = %8d   deletes = %8d", BUFF_SIZES[BUFF_SIZES.length - 1], BufferPool.instance.requests[BufferPool.instance.requests.length - 1].get(), BufferPool.instance.deletes[BufferPool.instance.deletes.length - 1].get());
        return str;
    }

    public static void enableStackTraceRecording(boolean record) {
        recordStackTraces = record;
    }
}

