/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.xtreemfs.foundation.buffer.ASCIIString;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.logging.Logging;

public final class ReusableBuffer {
    private static final Charset ENC_UTF8 = Charset.forName("utf-8");
    private ByteBuffer buffer;
    private final ByteBuffer parentBuffer;
    private final boolean reusable;
    protected volatile boolean returned;
    private int size;
    protected ReusableBuffer viewParent;
    protected String freeStack;
    protected String allocStack;
    AtomicInteger refCount;

    protected ReusableBuffer(ByteBuffer buffer, int size) {
        buffer.position(0);
        buffer.limit(size);
        this.buffer = buffer.slice();
        this.parentBuffer = buffer;
        this.size = size;
        this.reusable = true;
        this.refCount = new AtomicInteger(1);
        this.returned = false;
        this.viewParent = null;
    }

    public ReusableBuffer(ByteBuffer nonManaged) {
        this.buffer = nonManaged;
        this.size = this.buffer.limit();
        this.reusable = false;
        this.parentBuffer = null;
        this.returned = false;
        this.refCount = new AtomicInteger(1);
        this.viewParent = null;
    }

    public static ReusableBuffer wrap(byte[] data) {
        return new ReusableBuffer(ByteBuffer.wrap(data));
    }

    public static ReusableBuffer wrap(byte[] data, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        if (offset + length > data.length) {
            throw new IllegalArgumentException("offset+length > buffer size (" + offset + "+" + length + " > " + data.length);
        }
        ByteBuffer tmp = ByteBuffer.wrap(data);
        tmp.position(offset);
        tmp.limit(offset + length);
        return new ReusableBuffer(tmp.slice());
    }

    public ReusableBuffer createViewBuffer() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (this.viewParent == null) {
            if (this.parentBuffer == null) {
                ReusableBuffer view = new ReusableBuffer(this.buffer.slice());
                view.viewParent = this;
                return view;
            }
            ReusableBuffer view = new ReusableBuffer(this.parentBuffer, this.size);
            view.viewParent = this;
            this.refCount.incrementAndGet();
            if (BufferPool.recordStackTraces) {
                view.allocStack = "\n";
                StackTraceElement[] stackTrace = new Exception().getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    view.allocStack = view.allocStack + stackTrace[i].toString() + (i < stackTrace.length - 1 ? "\n" : "");
                }
            }
            return view;
        }
        if (this.parentBuffer == null) {
            ReusableBuffer view = new ReusableBuffer(this.buffer.slice());
            view.viewParent = this.viewParent;
            return view;
        }
        ReusableBuffer view = new ReusableBuffer(this.buffer, this.size);
        view.viewParent = this.viewParent;
        this.viewParent.refCount.incrementAndGet();
        if (BufferPool.recordStackTraces) {
            view.allocStack = "\n";
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                view.allocStack = view.allocStack + stackTrace[i].toString() + (i < stackTrace.length - 1 ? "\n" : "");
            }
        }
        return view;
    }

    public int capacity() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.size;
    }

    public int capacityUnderlying() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.parentBuffer != null ? this.parentBuffer.capacity() : this.size;
    }

    public boolean hasArray() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.hasArray();
    }

    public byte[] array() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        byte[] array = null;
        if (this.hasArray() && this.viewParent == null) {
            array = this.buffer.array();
        } else {
            array = new byte[this.limit()];
            int oldPos = this.position();
            this.position(0);
            this.get(array);
            this.position(oldPos);
        }
        return array;
    }

    public void flip() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.flip();
    }

    public void compact() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.compact();
    }

    public void limit(int l) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.limit(l);
    }

    public int limit() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.limit();
    }

    public void position(int p) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.position(p);
    }

    public int position() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.position();
    }

    public boolean hasRemaining() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.hasRemaining();
    }

    public ByteBuffer getBuffer() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    protected ByteBuffer getParent() {
        return this.parentBuffer;
    }

    public byte get() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.get();
    }

    public byte get(int index) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.get(index);
    }

    public ReusableBuffer get(byte[] dst) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.get(dst);
        return this;
    }

    public ReusableBuffer get(byte[] dst, int offset, int length) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.get(dst, offset, length);
        return this;
    }

    public ReusableBuffer put(byte b) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(b);
        return this;
    }

    public ReusableBuffer put(byte[] src) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(src);
        return this;
    }

    public ReusableBuffer put(byte[] src, int offset, int len) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(src, offset, len);
        return this;
    }

    public ReusableBuffer put(ByteBuffer src) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(src);
        return this;
    }

    public ReusableBuffer put(ReusableBuffer src) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(src.buffer);
        return this;
    }

    public int getInt() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.getInt();
    }

    public ReusableBuffer putInt(int i) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.putInt(i);
        return this;
    }

    public long getLong() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.getLong();
    }

    public ReusableBuffer putLong(long l) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.putLong(l);
        return this;
    }

    public double getDouble() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.getDouble();
    }

    public ReusableBuffer putDouble(double d) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.putDouble(d);
        return this;
    }

    public String getString() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        int length = this.buffer.getInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            this.buffer.get(bytes);
            return new String(bytes, ENC_UTF8);
        }
        if (length == 0) {
            return "";
        }
        return null;
    }

    public ReusableBuffer putString(String str) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (str != null) {
            byte[] bytes = str.getBytes(ENC_UTF8);
            this.buffer.putInt(bytes.length);
            this.buffer.put(bytes);
        } else {
            this.buffer.putInt(-1);
        }
        return this;
    }

    public ReusableBuffer putShortString(String str) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        assert (str.length() <= Short.MAX_VALUE);
        if (str != null) {
            byte[] bytes = str.getBytes(ENC_UTF8);
            this.buffer.putShort((short)bytes.length);
            this.buffer.put(bytes);
        } else {
            this.buffer.putInt(-1);
        }
        return this;
    }

    public ASCIIString getBufferBackedASCIIString() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return ASCIIString.unmarshall(this);
    }

    public ReusableBuffer putBufferBackedASCIIString(ASCIIString str) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (str != null) {
            str.marshall(this);
        } else {
            this.buffer.putInt(-1);
        }
        return this;
    }

    public ReusableBuffer putShort(short s) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.putShort(s);
        return this;
    }

    public short getShort() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.getShort();
    }

    public boolean isDirect() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.isDirect();
    }

    public int remaining() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.remaining();
    }

    public void clear() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.clear();
    }

    public byte[] getData() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        byte[] array = new byte[this.limit()];
        this.position(0);
        this.get(array);
        return array;
    }

    public void shrink(int newSize) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (newSize > this.size) {
            throw new IllegalArgumentException("new size must not be larger than old size");
        }
        this.size = newSize;
        int oldPos = this.buffer.position();
        if (oldPos > newSize) {
            oldPos = 0;
        }
        ByteBuffer originalBuffer = this.parentBuffer != null ? this.parentBuffer : this.buffer;
        int position = originalBuffer.position();
        int limit = originalBuffer.limit();
        originalBuffer.position(0);
        originalBuffer.limit(newSize);
        this.buffer = originalBuffer.slice();
        this.buffer.position(oldPos);
        originalBuffer.position(position);
        originalBuffer.limit(limit);
    }

    public boolean enlarge(int newSize) {
        ByteBuffer underlyingBuffer;
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (newSize == this.size) {
            return true;
        }
        if (this.parentBuffer == null && this.viewParent == null) {
            return false;
        }
        ByteBuffer byteBuffer = underlyingBuffer = this.parentBuffer != null ? this.parentBuffer : this.viewParent.getBuffer();
        if (newSize > underlyingBuffer.capacity()) {
            return false;
        }
        this.size = newSize;
        int oldPos = this.buffer.position();
        if (oldPos > newSize) {
            oldPos = 0;
        }
        int position = underlyingBuffer.position();
        int limit = underlyingBuffer.limit();
        underlyingBuffer.position(0);
        underlyingBuffer.limit(newSize);
        this.buffer = underlyingBuffer.slice();
        this.buffer.position(oldPos);
        underlyingBuffer.position(position);
        underlyingBuffer.limit(limit);
        return true;
    }

    public void range(int offset, int length) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        if (offset == 0 && length == this.size) {
            return;
        }
        if (offset >= this.size) {
            throw new IllegalArgumentException("offset must be < size. offset=" + offset + " size=" + this.size);
        }
        if (offset + length > this.size) {
            throw new IllegalArgumentException("offset+length must be <= size. size=" + this.size + " offset=" + offset + " length=" + length);
        }
        this.size = length;
        ByteBuffer originalBuffer = this.parentBuffer != null ? this.parentBuffer : this.buffer;
        int position = originalBuffer.position();
        int limit = originalBuffer.limit();
        if (offset > limit) {
            originalBuffer.limit(offset);
        }
        originalBuffer.position(offset);
        originalBuffer.limit(offset + length);
        this.buffer = originalBuffer.slice();
        assert (this.buffer.capacity() == length);
        originalBuffer.position(position);
        originalBuffer.limit(limit);
    }

    public ReusableBuffer putBoolean(boolean bool) {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        this.buffer.put(bool ? (byte)1 : 0);
        return this;
    }

    public boolean getBoolean() {
        assert (!this.returned) : "Buffer was already freed and cannot be used anymore" + this.freeStack;
        return this.buffer.get() == 1;
    }

    public int getRefCount() {
        if (this.viewParent == null) {
            return this.refCount.get();
        }
        return this.viewParent.refCount.get();
    }

    protected void finalize() {
        if (!this.returned && this.reusable) {
            Logging.logMessage(4, Logging.Category.buffer, this, "buffer was finalized but not freed before! buffer = %s, refCount=%d", this.toString(), this.getRefCount());
            if (this.allocStack != null) {
                Logging.logMessage(4, Logging.Category.buffer, this, "stacktrace: %s", this.allocStack);
                if (this.viewParent != null) {
                    Logging.logMessage(4, Logging.Category.buffer, this, "parent stacktrace: %s", this.viewParent.allocStack);
                }
            }
            if (this.freeStack != null) {
                Logging.logMessage(4, Logging.Category.buffer, this, "freed at: %s", this.freeStack);
            } else if (this.viewParent != null && this.viewParent.freeStack != null) {
                Logging.logMessage(4, Logging.Category.buffer, this, "freed at: %s", this.viewParent.freeStack);
            }
            if (Logging.isDebug()) {
                byte[] data = new byte[this.capacity() > 128 ? 128 : this.capacity()];
                this.position(0);
                this.limit(this.capacity());
                this.get(data);
                String content = new String(data);
                Logging.logMessage(4, Logging.Category.buffer, this, "content: %s", content);
                if (this.viewParent != null) {
                    Logging.logMessage(4, Logging.Category.buffer, this, "view parent: %s", this.viewParent.toString());
                    Logging.logMessage(4, Logging.Category.buffer, this, "ref count: %d", this.viewParent.refCount.get());
                } else {
                    Logging.logMessage(4, Logging.Category.buffer, this, "ref count: %d", this.refCount.get());
                }
            }
            BufferPool.free(this);
        }
    }

    public String toString() {
        return "ReusableBuffer( capacity=" + this.capacity() + " limit=" + this.limit() + " position=" + this.position() + ")";
    }
}

