/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.checksums;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xtreemfs.foundation.checksums.ChecksumAlgorithm;
import org.xtreemfs.foundation.checksums.ChecksumProvider;

public class ChecksumFactory {
    private static int MAX_CACHE_SIZE = 20;
    private static ChecksumFactory self;
    private HashMap<String, ChecksumAlgorithm> algorithms = new HashMap();
    private HashMap<String, ChecksumProvider> knownProvider;
    private HashMap<String, ConcurrentLinkedQueue<ChecksumAlgorithm>> pool = new HashMap();

    private ChecksumFactory() {
        this.knownProvider = new HashMap();
    }

    public static ChecksumFactory getInstance() {
        if (self == null) {
            self = new ChecksumFactory();
        }
        return self;
    }

    public ChecksumAlgorithm getAlgorithm(String name) throws NoSuchAlgorithmException {
        ConcurrentLinkedQueue<ChecksumAlgorithm> cache = this.pool.get(name);
        if (cache == null) {
            throw new NoSuchAlgorithmException("algorithm " + name + " not supported");
        }
        ChecksumAlgorithm algorithm = cache.poll();
        if (algorithm == null) {
            return this.algorithms.get(name).clone();
        }
        return algorithm;
    }

    public void returnAlgorithm(ChecksumAlgorithm algorithm) {
        ConcurrentLinkedQueue<ChecksumAlgorithm> cache = this.pool.get(algorithm.getName());
        if (cache.size() < MAX_CACHE_SIZE) {
            algorithm.reset();
            cache.add(algorithm);
        }
    }

    public void addProvider(ChecksumProvider provider) {
        this.knownProvider.put(provider.getName(), provider);
        for (ChecksumAlgorithm algorithm : provider.getSupportedAlgorithms()) {
            this.addAlgorithm(algorithm);
        }
    }

    public void addAlgorithm(ChecksumAlgorithm algorithm) {
        this.algorithms.put(algorithm.getName(), algorithm);
        this.pool.put(algorithm.getName(), new ConcurrentLinkedQueue());
    }

    public void removeProvider(ChecksumProvider provider) {
        this.knownProvider.remove(provider.getName());
    }

    public void removeAlgorithm(String algorithm) {
        this.algorithms.remove(algorithm);
        this.pool.remove(algorithm);
    }
}

