/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.checksums.algorithms;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.xtreemfs.foundation.checksums.ChecksumAlgorithm;

public abstract class JavaChecksumAlgorithm<RealJavaAlgorithm extends Checksum>
implements ChecksumAlgorithm {
    protected RealJavaAlgorithm realAlgorithm;
    protected String name;

    public JavaChecksumAlgorithm(RealJavaAlgorithm realAlgorithm, String name) {
        this.realAlgorithm = realAlgorithm;
        this.name = name;
    }

    @Override
    public void update(ByteBuffer data) {
        byte[] array;
        if (data.hasArray()) {
            array = data.array();
        } else {
            array = new byte[data.capacity()];
            int oldPos = data.position();
            data.position(0);
            data.get(array);
            data.position(oldPos);
        }
        this.realAlgorithm.update(array, 0, array.length);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getValue() {
        long tmp = this.realAlgorithm.getValue();
        this.realAlgorithm.reset();
        return tmp;
    }

    @Override
    public void reset() {
        this.realAlgorithm.reset();
    }

    @Override
    public abstract JavaChecksumAlgorithm<?> clone();
}

