/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.checksums.algorithms;

import java.nio.ByteBuffer;
import org.xtreemfs.foundation.checksums.StringChecksumAlgorithm;

public class JavaHash
implements StringChecksumAlgorithm {
    private Long hash = null;
    private String name = "Java-Hash";

    @Override
    public void digest(String data) {
        this.hash = data.hashCode();
    }

    @Override
    public void update(ByteBuffer data) {
        byte[] array;
        if (data.hasArray()) {
            array = data.array();
        } else {
            array = new byte[data.capacity()];
            int oldPos = data.position();
            data.position(0);
            data.get(array);
            data.position(oldPos);
        }
        this.hash = new String(array).hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getValue() {
        long value = this.hash != null ? this.hash : 0L;
        this.reset();
        return value;
    }

    @Override
    public void reset() {
        this.hash = null;
    }

    @Override
    public JavaHash clone() {
        return new JavaHash();
    }
}

