/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.checksums.algorithms;

import java.nio.ByteBuffer;
import org.xtreemfs.foundation.checksums.StringChecksumAlgorithm;

public class SDBM
implements StringChecksumAlgorithm {
    private Long hash = null;
    private String name = "SDBM";

    @Override
    public void digest(String data) {
        this.hash = SDBM.sdbmHash(data);
    }

    @Override
    public void update(ByteBuffer data) {
        byte[] array;
        if (data.hasArray()) {
            array = data.array();
        } else {
            array = new byte[data.capacity()];
            int oldPos = data.position();
            data.position(0);
            data.get(array);
            data.position(oldPos);
        }
        this.hash = SDBM.sdbmHash(new String(array));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getValue() {
        long value = this.hash != null ? this.hash : 0L;
        this.reset();
        return value;
    }

    @Override
    public void reset() {
        this.hash = null;
    }

    @Override
    public SDBM clone() {
        return new SDBM();
    }

    protected static long sdbmHash(String str) {
        long hash = 0L;
        for (char c : str.toCharArray()) {
            hash = (long)c + (hash << 6) + (hash << 16) - hash;
        }
        return hash;
    }
}

