/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.json;

import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONInput;

public class JSONCharBufferString
implements JSONInput {
    CharBuffer cb;

    public JSONCharBufferString(CharBuffer cb) {
        assert (cb != null);
        this.cb = cb;
        this.cb.position(0);
    }

    @Override
    public char read() throws JSONException {
        try {
            return this.cb.get();
        }
        catch (BufferUnderflowException ex) {
            throw new JSONException("Reached end of buffer");
        }
    }

    @Override
    public int skip(int skip) {
        try {
            this.cb.position(this.cb.position() + skip);
            return skip;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    @Override
    public String toString() {
        return "JSONCharBufferString backed by " + this.cb.toString();
    }

    @Override
    public boolean hasMore() {
        return this.cb.hasRemaining();
    }
}

