/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.json;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONInput;

public class JSONParser {
    private static String parseString(JSONInput input) throws JSONException {
        boolean nonEscaped = true;
        StringBuilder str = new StringBuilder();
        while (input.hasMore()) {
            char ch = input.read();
            if (nonEscaped) {
                if (ch == '\\') {
                    nonEscaped = false;
                    continue;
                }
                if (ch == '\"') {
                    return str.toString();
                }
                str.append(ch);
            } else if (ch == 'n') {
                str.append('\n');
            } else if (ch == 'r') {
                str.append('\r');
            } else if (ch == 't') {
                str.append('\t');
            } else {
                str.append(ch);
            }
            nonEscaped = true;
        }
        throw new JSONException("[ E | JSONParser ] Unexpected end while parsing string");
    }

    private static Object parseNumber(JSONInput input) throws JSONException {
        StringBuilder str = new StringBuilder();
        input.skip(-1);
        boolean isFP = false;
        while (input.hasMore()) {
            char ch = input.read();
            if (ch == '-' || ch >= '0' && ch <= '9') {
                str.append(ch);
                continue;
            }
            if (ch == '.' || ch == 'E' || ch == 'e') {
                str.append(ch);
                isFP = true;
                continue;
            }
            input.skip(-1);
            if (isFP) {
                return new BigDecimal(str.toString());
            }
            return Long.valueOf(str.toString());
        }
        if (isFP) {
            return new BigDecimal(str.toString());
        }
        return Long.valueOf(str.toString());
    }

    private static Object parseArray(JSONInput input) throws JSONException {
        LinkedList<Object> arr = new LinkedList<Object>();
        while (input.hasMore()) {
            char ch = input.read();
            if (ch == ']') {
                return arr;
            }
            if (ch == ',') {
                arr.add(JSONParser.parseJSON(input));
                continue;
            }
            if (ch == ' ' || ch == '\t') continue;
            input.skip(-1);
            arr.add(JSONParser.parseJSON(input));
        }
        throw new JSONException("[ E | JSONParser ] Unexpected end while parsing array");
    }

    private static Object parseObject(JSONInput input) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (input.hasMore()) {
            char ch = input.read();
            if (ch == '}') {
                return map;
            }
            if (ch == ' ' || ch == '\t') continue;
            String name = JSONParser.parseString(input);
            ch = input.read();
            while (ch == ' ' || ch == '\t') {
                ch = input.read();
            }
            if (ch != ':') {
                throw new JSONException("[ E | JSONParser ] Unexpected token '" + ch + "' or EOF. Expected : in Object.");
            }
            while (ch == ' ' || ch == '\t') {
                ch = input.read();
            }
            Object value = JSONParser.parseJSON(input);
            map.put(name, value);
            ch = input.read();
            while (ch == ' ' || ch == '\t') {
                ch = input.read();
            }
            if (ch == '}') {
                return map;
            }
            if (ch == ',') continue;
            throw new JSONException("[ E | JSONParser ] Unexpected token '" + ch + "' or EOF. Expected , or } in Object.");
        }
        throw new JSONException("[ E | JSONParser ] Unexpected end while parsing object");
    }

    public static Object parseJSON(JSONInput input) throws JSONException {
        while (input.hasMore()) {
            char ch = input.read();
            if (ch == '[') {
                return JSONParser.parseArray(input);
            }
            if (ch == '{') {
                return JSONParser.parseObject(input);
            }
            if (ch == '\"') {
                return JSONParser.parseString(input);
            }
            if (ch == '-' || ch >= '0' && ch <= '9') {
                return JSONParser.parseNumber(input);
            }
            if (ch == 't') {
                input.skip(3);
                return true;
            }
            if (ch == 'f') {
                input.skip(4);
                return false;
            }
            if (ch == 'n') {
                input.skip(3);
                return null;
            }
            if (ch == ' ' || ch == '\t') continue;
            throw new JSONException("[ E | JSONParser ] Unexpected token '" + ch + "' expected Object, Array or Value.");
        }
        throw new JSONException("[ E | JSONParser ] Unexpected end while parsing root element");
    }

    public static String writeJSON(Object input) throws JSONException {
        return JSONParser.writeJSON(input, new StringBuilder()).toString();
    }

    public static StringBuilder writeJSON(Object input, StringBuilder result) throws JSONException {
        if (input == null) {
            return result.append("null");
        }
        if (input instanceof Boolean) {
            return result.append((Boolean)input != false ? "true" : "false");
        }
        if (input instanceof BigDecimal) {
            return result.append(((BigDecimal)input).toString());
        }
        if (input instanceof Integer) {
            return result.append((Integer)input);
        }
        if (input instanceof Long) {
            return result.append((Long)input);
        }
        if (input instanceof String) {
            return JSONParser.writeJSONString(input, result);
        }
        if (input instanceof Map) {
            return JSONParser.writeJSONObject(input, result);
        }
        if (input instanceof Collection) {
            return JSONParser.writeJSONArray(input, result);
        }
        throw new JSONException("[ E | JSONParser ] Unexpected Object type: " + input.getClass().getName());
    }

    private static StringBuilder writeJSONObject(Object input, StringBuilder result) throws JSONException {
        Map map = (Map)input;
        result.append("{");
        int i = 1;
        for (Object key : map.keySet()) {
            JSONParser.writeJSONString(key.toString(), result);
            result.append(":");
            JSONParser.writeJSON(map.get(key), result);
            if (i < map.size()) {
                result.append(",");
            }
            ++i;
        }
        return result.append("}");
    }

    private static StringBuilder writeJSONArray(Object input, StringBuilder result) throws JSONException {
        Collection arr = (Collection)input;
        result.append("[");
        int i = 1;
        for (Object obj : arr) {
            JSONParser.writeJSON(obj, result);
            if (i < arr.size()) {
                result.append(",");
            }
            ++i;
        }
        return result.append("]");
    }

    private static StringBuilder writeJSONString(Object input, StringBuilder result) {
        String str = input.toString();
        result.append("\"");
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    result.append("\\n");
                    continue block8;
                }
                case '\r': {
                    result.append("\\r");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block8;
                }
                case '/': {
                    result.append("\\/");
                    continue block8;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        result.append("\"");
        return result;
    }

    public static String toJSON(Object ... args) throws JSONException {
        ArrayList<Object> argList = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            argList.add(arg);
        }
        return JSONParser.writeJSON(argList);
    }
}

