/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.json;

import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONInput;

public class JSONString
implements JSONInput {
    String str;
    int position;

    public JSONString(String str) {
        this.str = str;
        this.position = 0;
    }

    @Override
    public char read() throws JSONException {
        try {
            return this.str.charAt(this.position++);
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new JSONException("Reach the end of the string");
        }
    }

    @Override
    public boolean hasMore() {
        return this.position < this.str.length();
    }

    @Override
    public int skip(int skip) {
        if (this.position + skip < 0 || this.position + skip >= this.str.length()) {
            return 0;
        }
        this.position += skip;
        return skip;
    }

    @Override
    public String toString() {
        return "JSONString pos=" + this.position + "   str=" + this.str;
    }
}

