/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.logging;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logging {
    protected static final char ABBREV_LEVEL_INFO = 'I';
    protected static final char ABBREV_LEVEL_DEBUG = 'D';
    protected static final char ABBREV_LEVEL_WARN = 'W';
    protected static final char ABBREV_LEVEL_ERROR = 'E';
    protected static final char ABBREV_LEVEL_TRACE = 'T';
    public static final int LEVEL_EMERG = 0;
    public static final int LEVEL_ALERT = 1;
    public static final int LEVEL_CRIT = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_WARN = 4;
    public static final int LEVEL_NOTICE = 5;
    public static final int LEVEL_INFO = 6;
    public static final int LEVEL_DEBUG = 7;
    public static final String FORMAT_PATTERN = "[ %c | %-20s | %-15s | %3d | %15s ] %s";
    private static PrintStream out = System.out;
    protected static Logging instance;
    protected static boolean tracingEnabled;
    private final int level;
    private final int catMask;
    private static final SimpleDateFormat dateFormat;

    private Logging(int level, int catMask) {
        this.level = level < 0 ? 0 : level;
        this.catMask = catMask;
        instance = this;
        System.currentTimeMillis();
    }

    public static void redirect(PrintStream out) {
        Logging.out = out;
    }

    public static String truncateString(String string, int maxLength) {
        return string.length() > maxLength ? string.substring(0, maxLength - 3) + "..." : string;
    }

    public static void logMessage(int level, Category cat, Object me, String formatPattern, Object ... args) {
        Logging.checkIfInitializedOrThrow();
        if (level <= Logging.instance.level && (cat == Category.all || (2 << cat.ordinal() & Logging.instance.catMask) > 0)) {
            char levelName = Logging.getLevelName(level);
            out.println(String.format(FORMAT_PATTERN, Character.valueOf(levelName), me == null ? "-" : Logging.truncateString(me instanceof Class ? ((Class)me).getSimpleName() : me.getClass().getSimpleName(), 20), Logging.truncateString(Thread.currentThread().getName(), 15), Thread.currentThread().getId(), Logging.getTimeStamp(), String.format(formatPattern, args)));
        }
    }

    private static void checkIfInitializedOrThrow() {
        if (instance == null) {
            throw new RuntimeException("Cannot log message because the logging is not initialized yet. Did you forget to call Logging.start(...) in your code?");
        }
    }

    public static void logMessage(int level, Object me, String formatPattern, Object ... args) {
        Logging.logMessage(level, Category.all, me, formatPattern, args);
    }

    public static void logError(int level, Object me, Throwable msg) {
        Logging.checkIfInitializedOrThrow();
        if (level <= Logging.instance.level) {
            char levelName = Logging.getLevelName(level);
            out.println(String.format(FORMAT_PATTERN, Character.valueOf(levelName), me == null ? "-" : (me instanceof Class ? ((Class)me).getSimpleName() : me.getClass().getSimpleName()), Thread.currentThread().getName(), Thread.currentThread().getId(), Logging.getTimeStamp(), msg.toString()));
            for (StackTraceElement elem : msg.getStackTrace()) {
                out.println(" ...                                           " + elem.toString());
            }
            if (msg.getCause() != null) {
                out.println(String.format(FORMAT_PATTERN, Character.valueOf(levelName), me == null ? "-" : me.getClass().getSimpleName(), Thread.currentThread().getName(), Thread.currentThread().getId(), Logging.getTimeStamp(), "root cause: " + msg.getCause()));
                for (StackTraceElement elem : msg.getCause().getStackTrace()) {
                    out.println(" ...                                           " + elem.toString());
                }
            }
        }
    }

    public static void logUserError(int level, Category cat, Object me, Throwable msg) {
        Logging.checkIfInitializedOrThrow();
        if (level <= Logging.instance.level && (cat == Category.all || (2 << cat.ordinal() & Logging.instance.catMask) > 0)) {
            char levelName = Logging.getLevelName(level);
            out.println(String.format(FORMAT_PATTERN, Character.valueOf(levelName), me == null ? "-" : me.getClass().getSimpleName(), Thread.currentThread().getName(), Thread.currentThread().getId(), Logging.getTimeStamp(), msg.toString()));
            for (StackTraceElement elem : msg.getStackTrace()) {
                out.println(" ...                                           " + elem.toString());
            }
        }
    }

    public static char getLevelName(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return 'E';
            }
            case 4: {
                return 'W';
            }
            case 5: 
            case 6: {
                return 'I';
            }
            case 7: {
                return 'D';
            }
        }
        return '?';
    }

    public static synchronized void start(int level, Category ... categories) {
        if (instance == null) {
            int catMask = 0;
            for (Category cat : categories) {
                if (cat == Category.all) {
                    catMask = -1;
                }
                catMask |= 2 << cat.ordinal();
            }
            if (categories.length == 0) {
                catMask = -1;
            }
            instance = new Logging(level, catMask);
        }
    }

    public static boolean isDebug() {
        if (instance == null) {
            return false;
        }
        return Logging.instance.level >= 7;
    }

    public static boolean isInfo() {
        if (instance == null) {
            return false;
        }
        return Logging.instance.level >= 6;
    }

    public static boolean isNotice() {
        if (instance == null) {
            return false;
        }
        return Logging.instance.level >= 5;
    }

    private static String getTimeStamp() {
        return dateFormat.format(new Date());
    }

    static {
        tracingEnabled = false;
        dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
    }

    public static enum Category {
        all,
        buffer,
        lifecycle,
        net,
        auth,
        stage,
        proc,
        misc,
        storage,
        replication,
        tool,
        test;

    }
}

