/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.monitoring;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xtreemfs.foundation.monitoring.MonitoringEvent;
import org.xtreemfs.foundation.monitoring.MonitoringListener;

public class Monitoring<V> {
    protected ConcurrentHashMap<String, V> datasets = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, List<MonitoringListener<V>>> listeners = new ConcurrentHashMap();
    private static boolean monitoringEnabled = false;

    public V put(String key, V value) {
        assert (key != null && value != null);
        V oldValue = this.datasets.put(key, value);
        if (this.listeners.containsKey(key)) {
            MonitoringEvent<V> event = new MonitoringEvent<V>(this, key, value);
            for (MonitoringListener<V> listener : this.listeners.get(key)) {
                listener.valueAddedOrChanged(event);
            }
        }
        return oldValue;
    }

    public V get(String key) {
        return this.datasets.get(key);
    }

    public boolean containsKey(String key) {
        return this.datasets.containsKey(key);
    }

    public Set<Map.Entry<String, V>> entrySet() {
        return this.datasets.entrySet();
    }

    public V remove(String key) {
        return this.datasets.remove(key);
    }

    public int size() {
        return this.datasets.size();
    }

    public String toString() {
        return this.datasets.toString();
    }

    public void registerListener(String key, MonitoringListener<V> listener) {
        List<MonitoringListener<V>> list = this.listeners.get(key);
        if (list == null) {
            list = new CopyOnWriteArrayList<MonitoringListener<V>>();
            this.listeners.put(key, list);
        }
        list.add(listener);
    }

    public void unregisterListener(String key, MonitoringListener<V> listener) {
        int index;
        List<MonitoringListener<V>> list = this.listeners.get(key);
        if (list != null && (index = list.indexOf(listener)) != -1) {
            list.remove(index);
        }
    }

    public static void enable() {
        monitoringEnabled = true;
    }

    public static boolean isEnabled() {
        return monitoringEnabled;
    }
}

