/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.monitoring;

import java.io.IOException;
import org.xtreemfs.foundation.monitoring.Monitoring;
import org.xtreemfs.foundation.monitoring.MonitoringEvent;
import org.xtreemfs.foundation.monitoring.MonitoringListener;

public class MonitoringLog
implements MonitoringListener<Double> {
    private static MonitoringLog instance;
    private long monitoringStartTime;

    public static synchronized void initialize(String filepath) throws IOException {
        if (instance == null) {
            instance = new MonitoringLog();
            MonitoringLog.instance.monitoringStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public void valueAddedOrChanged(MonitoringEvent<Double> event) {
        MonitoringLog.monitor(event.getKey(), event.getNewValue().toString());
    }

    public static synchronized void monitor(String key, String value) {
        long time = (System.currentTimeMillis() - MonitoringLog.instance.monitoringStartTime) / 1000L;
        System.out.println("[" + time + "s]\t" + key + "\t:\t" + value);
    }

    public static void registerFor(Monitoring monitoring, String ... keys) {
        for (String key : keys) {
            monitoring.registerListener(key, instance);
        }
    }
}

