/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.channels.ChannelIO;
import org.xtreemfs.foundation.util.OutputUtils;

public class SSLChannelIO
extends ChannelIO {
    protected final SSLEngine sslEngine;
    protected ReusableBuffer inNetBuffer;
    protected ReusableBuffer inReadBuffer;
    protected ReusableBuffer outNetBuffer;
    protected ReusableBuffer dummyBuffer;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;
    protected boolean handshakeComplete;
    protected int keyOpsBeforeHandshake = -1;
    protected boolean shutdownInProgress;
    protected static String[] supportedCipherSuitesWithoutEncryption = null;
    protected boolean clientMode;
    private boolean closed = false;
    private boolean shutdownComplete = false;

    public SSLChannelIO(SocketChannel channel, SSLOptions sslOptions, boolean clientMode) throws SSLException {
        super(channel);
        this.sslEngine = sslOptions.getSSLContext().createSSLEngine();
        this.sslEngine.setUseClientMode(clientMode);
        this.sslEngine.setNeedClientAuth(true);
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        for (String protocol : this.sslEngine.getSupportedProtocols()) {
            if (!sslOptions.isSSLEngineProtocolSupported(protocol) || enabledProtocols.contains(protocol)) continue;
            enabledProtocols.add(protocol);
        }
        Object[] enabledProtocolsArray = enabledProtocols.toArray(new String[enabledProtocols.size()]);
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "Enabling the following protocols: %s", Arrays.toString(enabledProtocolsArray));
        }
        this.sslEngine.setEnabledProtocols((String[])enabledProtocolsArray);
        if (clientMode) {
            this.sslEngine.beginHandshake();
            this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        } else {
            this.sslEngine.beginHandshake();
            this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        this.handshakeComplete = false;
        this.shutdownInProgress = false;
        int netBufSize = this.sslEngine.getSession().getPacketBufferSize();
        this.inNetBuffer = BufferPool.allocate(netBufSize);
        this.inReadBuffer = BufferPool.allocate(this.sslEngine.getSession().getApplicationBufferSize() * 2);
        this.outNetBuffer = BufferPool.allocate(netBufSize);
        this.dummyBuffer = BufferPool.allocate(netBufSize);
        if (sslOptions.isAuthenticationWithoutEncryption()) {
            if (supportedCipherSuitesWithoutEncryption == null) {
                ArrayList<String> cipherSuites = new ArrayList<String>();
                for (String cipherSuite : this.sslEngine.getSupportedCipherSuites()) {
                    if (!cipherSuite.contains("WITH_NULL")) continue;
                    cipherSuites.add(cipherSuite);
                }
                supportedCipherSuitesWithoutEncryption = new String[cipherSuites.size()];
                supportedCipherSuitesWithoutEncryption = cipherSuites.toArray(supportedCipherSuitesWithoutEncryption);
            }
            this.sslEngine.setEnabledCipherSuites(supportedCipherSuitesWithoutEncryption);
        } else {
            this.sslEngine.setEnabledCipherSuites(this.sslEngine.getSupportedCipherSuites());
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int returnValue = 0;
        if (!this.shutdownInProgress && this.handshakeComplete) {
            if (this.inReadBuffer.remaining() == this.inReadBuffer.capacity()) {
                if (this.channel.read(this.inNetBuffer.getBuffer()) == -1) {
                    return -1;
                }
                this.inNetBuffer.flip();
                block6: while (this.inNetBuffer.hasRemaining()) {
                    SSLEngineResult result = this.sslEngine.unwrap(this.inNetBuffer.getBuffer(), this.inReadBuffer.getBuffer());
                    switch (result.getStatus()) {
                        case OK: {
                            if (!this.sslEngine.isInboundDone()) continue block6;
                            this.close();
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            break block6;
                        }
                        case BUFFER_OVERFLOW: {
                            throw new IOException("BufferOverflow in the SSLEngine: Destination-Buffer is too small.");
                        }
                        case CLOSED: {
                            throw new IOException("The SSLEngine is already closed.");
                        }
                        default: {
                            throw new IOException("The SSLEngine is in an undefined state.");
                        }
                    }
                }
                this.inNetBuffer.compact();
            }
            this.inReadBuffer.flip();
            if (dst.remaining() >= this.inReadBuffer.remaining()) {
                returnValue += this.inReadBuffer.remaining();
                dst.put(this.inReadBuffer.getBuffer());
            } else {
                while (this.inReadBuffer.hasRemaining() && dst.hasRemaining()) {
                    dst.put(this.inReadBuffer.get());
                    ++returnValue;
                }
            }
            this.inReadBuffer.compact();
        }
        return returnValue;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int returnValue = 0;
        if (!this.shutdownInProgress && this.handshakeComplete) {
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer.getBuffer());
            this.outNetBuffer.flip();
            switch (result.getStatus()) {
                case OK: {
                    this.tryFlush();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.tryFlush();
                    break;
                }
                case CLOSED: {
                    throw new IOException("The SSLEngine is already closed.");
                }
                default: {
                    throw new IOException("The SSLEngine is in a curiuos state.");
                }
            }
            returnValue = result.bytesConsumed();
        }
        return returnValue;
    }

    @Override
    public long write(ByteBuffer[] src) throws IOException {
        int returnValue = 0;
        if (!this.shutdownInProgress && this.handshakeComplete) {
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer.getBuffer());
            this.outNetBuffer.flip();
            switch (result.getStatus()) {
                case OK: {
                    this.tryFlush();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.tryFlush();
                    break;
                }
                case CLOSED: {
                    throw new IOException("The SSLEngine is already closed.");
                }
                default: {
                    throw new IOException("The SSLEngine is in a curiuos state.");
                }
            }
            returnValue = result.bytesConsumed();
        }
        return returnValue;
    }

    @Override
    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    @Override
    public boolean shutdown(SelectionKey key) throws IOException, CancelledKeyException {
        if (!this.handshakeComplete) {
            this.shutdownInProgress = true;
            return true;
        }
        if (this.shutdownComplete) {
            return this.shutdownComplete;
        }
        if (!this.shutdownInProgress) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.net, this, "shutdown SSL connection of %s:%d", this.channel.socket().getInetAddress().toString(), this.channel.socket().getPort());
            }
            this.sslEngine.closeOutbound();
            this.shutdownInProgress = true;
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
        }
        this.outNetBuffer.flip();
        if (this.tryFlush() && this.sslEngine.isOutboundDone()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            this.shutdownComplete = true;
        }
        if (!this.sslEngine.isOutboundDone()) {
            SSLEngineResult result = this.sslEngine.wrap(this.dummyBuffer.getBuffer(), this.outNetBuffer.getBuffer());
            this.outNetBuffer.flip();
            switch (result.getStatus()) {
                case OK: {
                    throw new IOException("This should not happen.");
                }
                case BUFFER_OVERFLOW: {
                    this.tryFlush();
                    key.interestOps(key.interestOps() | 4);
                    break;
                }
                case CLOSED: {
                    if (this.tryFlush() && this.sslEngine.isOutboundDone()) {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                        this.shutdownComplete = true;
                        break;
                    }
                    key.interestOps(key.interestOps() | 4);
                    break;
                }
                default: {
                    throw new IOException("The SSLEngine is in a curiuos state.");
                }
            }
        }
        return this.shutdownComplete;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            try {
                this.sslEngine.closeInbound();
                this.sslEngine.closeOutbound();
            }
            catch (SSLException e) {
                // empty catch block
            }
            BufferPool.free(this.inNetBuffer);
            this.inNetBuffer = null;
            BufferPool.free(this.inReadBuffer);
            this.inReadBuffer = null;
            BufferPool.free(this.outNetBuffer);
            BufferPool.free(this.dummyBuffer);
            this.shutdownInProgress = true;
            this.closed = true;
        }
        catch (Throwable th) {
            System.out.println("CANNOT CLOSE DUE TO: " + th);
            throw new IOException(th);
        }
    }

    protected void finalize() {
        if (this.inNetBuffer != null) {
            Logging.logMessage(3, Logging.Category.misc, this, "buffers not freed!", new Object[0]);
            BufferPool.free(this.inNetBuffer);
            this.inNetBuffer = null;
            BufferPool.free(this.outNetBuffer);
            BufferPool.free(this.dummyBuffer);
        }
        if (!this.closed) {
            System.out.println("CONNECTION WAS NOT CLOSED PROPERLY: " + this);
        }
    }

    protected boolean tryFlush() throws IOException {
        this.channel.write(this.outNetBuffer.getBuffer());
        if (this.outNetBuffer.hasRemaining()) {
            this.outNetBuffer.compact();
            return false;
        }
        this.outNetBuffer.compact();
        return true;
    }

    @Override
    public boolean doHandshake(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.handshakeComplete || this.shutdownInProgress) {
            return this.handshakeComplete;
        }
        if (this.keyOpsBeforeHandshake == -1) {
            this.keyOpsBeforeHandshake = key.interestOps();
            key.interestOps(key.interestOps() & 0xFFFFFFFE & 0xFFFFFFFB);
        }
        if (!this.handshakeComplete) {
            block0 : switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    if (this.channel.read(this.inNetBuffer.getBuffer()) == -1) {
                        throw new IOException("End of stream has reached.");
                    }
                    boolean underflow = false;
                    do {
                        this.inNetBuffer.flip();
                        SSLEngineResult result = this.sslEngine.unwrap(this.inNetBuffer.getBuffer(), this.dummyBuffer.getBuffer());
                        this.inNetBuffer.compact();
                        this.handshakeStatus = result.getHandshakeStatus();
                        switch (result.getStatus()) {
                            case OK: {
                                this.analyseHandshakeStatus(key, this.handshakeStatus);
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                underflow = true;
                                key.interestOps(key.interestOps() | 1);
                                break;
                            }
                            case CLOSED: {
                                throw new IOException("The SSLEngine is already closed.");
                            }
                            default: {
                                throw new IOException("The SSLEngine is in a curiuos state.");
                            }
                        }
                    } while (this.bufferRemaining(this.inNetBuffer) != 0 && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && !underflow);
                    break;
                }
                case NEED_WRAP: {
                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                    SSLEngineResult result = this.sslEngine.wrap(this.dummyBuffer.getBuffer(), this.outNetBuffer.getBuffer());
                    this.outNetBuffer.flip();
                    this.handshakeStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            this.tryFlush();
                            this.analyseHandshakeStatus(key, this.handshakeStatus);
                            break block0;
                        }
                        case BUFFER_OVERFLOW: {
                            this.tryFlush();
                            key.interestOps(key.interestOps() | 4);
                            break block0;
                        }
                        case CLOSED: {
                            throw new IOException("The SSLEngine is already closed.");
                        }
                    }
                    throw new IOException("The SSLEngine is in a curiuos state.");
                }
                case FINISHED: {
                    this.outNetBuffer.flip();
                    if (this.tryFlush()) {
                        this.handshakeFinished(key);
                        break;
                    }
                    key.interestOps(key.interestOps() | 4);
                    break;
                }
                case NEED_TASK: {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    this.doTasks(key);
                    break;
                }
                case NOT_HANDSHAKING: {
                    throw new IOException("The SSLEngine is not handshaking.");
                }
                default: {
                    throw new IOException("The SSLEngine is in a curiuos handshake-state.");
                }
            }
        }
        return this.handshakeComplete;
    }

    @Override
    public boolean isFlushed() {
        return this.bufferRemaining(this.outNetBuffer) == 0;
    }

    private void handshakeFinished(SelectionKey key) throws CancelledKeyException {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, "SSL-handshake for %s:%d finished", this.channel.socket().getInetAddress().toString(), this.channel.socket().getPort());
        }
        this.handshakeComplete = true;
        this.inNetBuffer.clear();
        this.outNetBuffer.clear();
        key.interestOps(this.keyOpsBeforeHandshake);
        try {
            this.certs = this.sslEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            Logging.logMessage(3, Logging.Category.auth, this, OutputUtils.stackTraceToString(ex), new Object[0]);
            this.certs = null;
        }
    }

    private void analyseHandshakeStatus(SelectionKey key, SSLEngineResult.HandshakeStatus handshakeStatus) throws IOException, CancelledKeyException {
        switch (handshakeStatus) {
            case NEED_UNWRAP: {
                key.interestOps(key.interestOps() | 1);
                break;
            }
            case NEED_WRAP: {
                key.interestOps(key.interestOps() | 4);
                break;
            }
            case NEED_TASK: {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                this.doTasks(key);
                break;
            }
            case FINISHED: {
                this.outNetBuffer.flip();
                if (this.tryFlush()) {
                    this.handshakeFinished(key);
                    break;
                }
                key.interestOps(key.interestOps() | 4);
                break;
            }
            case NOT_HANDSHAKING: {
                throw new IOException("The SSLEngine is not handshaking.");
            }
            default: {
                throw new IOException("The SSLEngine is in a curiuos handshake-state.");
            }
        }
    }

    private int bufferRemaining(ReusableBuffer buffer) {
        buffer.flip();
        int tmp = buffer.remaining();
        buffer.compact();
        return tmp;
    }

    protected void doTasks(SelectionKey key) throws CancelledKeyException {
        Runnable run;
        int tmp = key.interestOps();
        key.interestOps(0);
        while ((run = this.sslEngine.getDelegatedTask()) != null) {
            run.run();
        }
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        switch (this.handshakeStatus) {
            case NEED_WRAP: {
                key.interestOps(tmp | 4);
                break;
            }
            case NEED_UNWRAP: {
                key.interestOps(tmp | 1);
                break;
            }
            case FINISHED: {
                this.handshakeFinished(key);
                break;
            }
            case NEED_TASK: {
                this.doTasks(key);
                break;
            }
            case NOT_HANDSHAKING: {
                Logging.logMessage(3, Logging.Category.auth, this, "Exception in worker-thread: The SSLEngine is not handshaking.", new Object[0]);
                break;
            }
            default: {
                Logging.logMessage(3, Logging.Category.auth, this, "Exception in worker-thread: The SSLEngine is in a curiuos handshake-state.", new Object[0]);
                assert (false);
                break;
            }
        }
    }
}

