/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.client;

import java.io.IOException;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class PBRPCException
extends IOException {
    final RPC.RPCHeader.ErrorResponse response;
    final String message;

    public PBRPCException(String ioError) {
        this.message = ioError;
        this.response = null;
    }

    public PBRPCException(RPC.RPCHeader.ErrorResponse response) {
        this.response = response;
        this.message = null;
    }

    public RPC.ErrorType getErrorType() {
        if (this.response != null) {
            return this.response.getErrorType();
        }
        return RPC.ErrorType.IO_ERROR;
    }

    public RPC.POSIXErrno getPOSIXErrno() {
        if (this.response != null) {
            return this.response.getPosixErrno();
        }
        return RPC.POSIXErrno.POSIX_ERROR_NONE;
    }

    public String getErrorMessage() {
        if (this.response != null) {
            return this.response.getErrorMessage();
        }
        return this.message;
    }

    public String getDebugInfo() {
        if (this.response != null) {
            return this.response.getDebugInfo();
        }
        return "";
    }

    public String getRedirectToServerUUID() {
        if (this.response != null) {
            return this.response.getRedirectToServerUuid();
        }
        return "";
    }

    public RPC.RPCHeader.ErrorResponse getErrorResponse() {
        return this.response;
    }

    @Override
    public String getMessage() {
        if (this.response != null) {
            return this.response.getErrorType().toString() + "/" + this.response.getPosixErrno().toString() + ": " + this.response.getErrorMessage() + " / " + this.response.getDebugInfo();
        }
        return this.message;
    }
}

