/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.client;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.channels.ChannelIO;
import org.xtreemfs.foundation.pbrpc.client.RPCClientRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServerConnection;

public class RPCClientConnection {
    public static final int RETRY_RESET_IN_MS = 500;
    public static final int MAX_RETRY_WAIT_MS = 60000;
    private ChannelIO channel;
    private final Map<Integer, RPCClientRequest> requests = new HashMap<Integer, RPCClientRequest>();
    private final List<RPCClientRequest> sendQueue;
    private long lastUsed = TimeSync.getLocalSystemTime();
    private long nextReconnectTime = 0L;
    private int numConnectAttempts = 0;
    private final ByteBuffer requestRecordMarker;
    private final ByteBuffer responseRecordMarker;
    private ReusableBuffer[] responseBuffers;
    private ByteBuffer[] requestBuffers;
    private RPCClientRequest pendingRequest;
    private RPCNIOSocketServerConnection.ReceiveState receiveState;
    private final InetSocketAddress endpoint;
    volatile long bytesRX;
    volatile long bytesTX;

    public RPCClientConnection(InetSocketAddress endpoint) {
        this.sendQueue = new LinkedList<RPCClientRequest>();
        this.requestRecordMarker = ByteBuffer.allocateDirect(12);
        this.responseRecordMarker = ByteBuffer.allocateDirect(12);
        this.endpoint = endpoint;
        this.receiveState = RPCNIOSocketServerConnection.ReceiveState.RECORD_MARKER;
        this.bytesTX = 0L;
        this.bytesRX = 0L;
    }

    public void freeBuffers() {
        if (this.responseBuffers != null) {
            for (ReusableBuffer buf : this.responseBuffers) {
                BufferPool.free(buf);
            }
        }
        for (RPCClientRequest rq : this.sendQueue) {
            rq.freeBuffers();
        }
        for (RPCClientRequest rq : this.requests.values()) {
            rq.freeBuffers();
        }
    }

    boolean isConnected() {
        return this.channel != null;
    }

    void connectFailed() {
        ++this.numConnectAttempts;
        long waitt = Math.round(500.0 * Math.pow(2.0, this.numConnectAttempts));
        if (waitt > 60000L) {
            waitt = 60000L;
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, "next reconnect possible after %d s, attempt = %d", waitt / 1000L, this.numConnectAttempts);
        }
        this.nextReconnectTime = System.currentTimeMillis() + waitt;
    }

    boolean canReconnect() {
        return this.nextReconnectTime < System.currentTimeMillis();
    }

    void setChannel(ChannelIO channel) {
        this.channel = channel;
    }

    void connected() {
        this.numConnectAttempts = 0;
        this.lastUsed = TimeSync.getLocalSystemTime();
    }

    void useConnection() {
        this.lastUsed = TimeSync.getLocalSystemTime();
    }

    long getLastUsed() {
        return this.lastUsed;
    }

    ChannelIO getChannel() {
        return this.channel;
    }

    RPCClientRequest getRequest(int callId) {
        return this.requests.remove(callId);
    }

    void addRequest(int callId, RPCClientRequest rq) {
        this.requests.put(callId, rq);
    }

    void removeRequest(int callId) {
        this.requests.remove(callId);
    }

    Map<Integer, RPCClientRequest> getRequests() {
        return this.requests;
    }

    List<RPCClientRequest> getSendQueue() {
        return this.sendQueue;
    }

    ByteBuffer getRequestRecordMarker() {
        return this.requestRecordMarker;
    }

    ByteBuffer getResponseRecordMarker() {
        return this.responseRecordMarker;
    }

    public String getEndpointString() {
        String endpointString = "unknown";
        try {
            endpointString = this.endpoint.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return endpointString;
    }

    public ByteBuffer[] getRequestBuffers() {
        return this.requestBuffers;
    }

    public void setRequestBuffers(ByteBuffer[] requestBuffers) {
        this.requestBuffers = requestBuffers;
    }

    public RPCClientRequest getPendingRequest() {
        return this.pendingRequest;
    }

    public void setPendingRequest(RPCClientRequest pendingRequest) {
        this.pendingRequest = pendingRequest;
    }

    public RPCNIOSocketServerConnection.ReceiveState getReceiveState() {
        return this.receiveState;
    }

    public void setReceiveState(RPCNIOSocketServerConnection.ReceiveState receiveState) {
        this.receiveState = receiveState;
    }

    public ReusableBuffer[] getResponseBuffers() {
        return this.responseBuffers;
    }

    public void setResponseBuffers(ReusableBuffer[] responseBuffers) {
        this.responseBuffers = responseBuffers;
    }
}

