/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.client;

import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferOutputStream;

public class RPCClientRequest<ReturnType extends Message> {
    private final RPC.RPCHeader requestHeader;
    private RPC.RPCHeader responseHeader;
    final ReusableBuffer[] buffers;
    final int hdrLen;
    final int msgLen;
    final int dataLen;
    private final RPCResponse response;
    private long timeQueued;
    private long bytesWritten;

    RPCClientRequest(RPC.Auth authHeader, RPC.UserCredentials uCreds, int callId, int interfaceId, int procId, Message message, ReusableBuffer data, RPCResponse<ReturnType> response) throws IOException {
        if (uCreds == null) {
            throw new IOException("No UserCredentials object given (null). Make sure it's set.");
        }
        if (authHeader == null) {
            throw new IOException("No Auth object given (null). Make sure it's set.");
        }
        RPC.RPCHeader.RequestHeader rqHdr = RPC.RPCHeader.RequestHeader.newBuilder().setAuthData(authHeader).setUserCreds(uCreds).setInterfaceId(interfaceId).setProcId(procId).build();
        this.requestHeader = RPC.RPCHeader.newBuilder().setCallId(callId).setMessageType(RPC.MessageType.RPC_REQUEST).setRequestHeader(rqHdr).build();
        this.response = response;
        ReusableBufferOutputStream os = new ReusableBufferOutputStream(8192);
        this.requestHeader.writeTo(os);
        this.hdrLen = os.length();
        if (message != null) {
            message.writeTo(os);
            this.msgLen = os.length() - this.hdrLen;
        } else {
            this.msgLen = 0;
        }
        if (data != null) {
            os.appendBuffer(data);
            this.dataLen = data.limit();
        } else {
            this.dataLen = 0;
        }
        assert (this.hdrLen > 0);
        assert (this.msgLen >= 0);
        assert (this.dataLen >= 0);
        os.flip();
        this.buffers = os.getBuffers();
    }

    public ReusableBuffer[] getBuffers() {
        return this.buffers;
    }

    public ByteBuffer[] packBuffers(ByteBuffer recordMarker) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "sending record marker: %d/%d/%d", this.hdrLen, this.msgLen, this.dataLen);
        }
        recordMarker.putInt(this.hdrLen);
        recordMarker.putInt(this.msgLen);
        recordMarker.putInt(this.dataLen);
        recordMarker.flip();
        ByteBuffer[] arr = new ByteBuffer[this.buffers.length + 1];
        arr[0] = recordMarker;
        for (int i = 0; i < this.buffers.length; ++i) {
            arr[i + 1] = this.buffers[i].getBuffer();
            if (!Logging.isDebug()) continue;
            Logging.logMessage(7, this, "send buffer #%d: %s", i + 1, this.buffers[i]);
        }
        return arr;
    }

    public void freeBuffers() {
        for (int i = 0; i < this.buffers.length; ++i) {
            BufferPool.free(this.buffers[i]);
            this.buffers[i] = null;
        }
    }

    public long getDuration() {
        if (RPCNIOSocketClient.ENABLE_STATISTICS) {
            return 0L;
        }
        return 0L;
    }

    public RPC.RPCHeader getRequestHeader() {
        return this.requestHeader;
    }

    void queued() {
        this.timeQueued = TimeSync.getLocalSystemTime();
    }

    long getTimeQueued() {
        return this.timeQueued;
    }

    public RPC.RPCHeader getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(RPC.RPCHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public RPCResponse<ReturnType> getResponse() {
        return this.response;
    }

    public void recordBytesWritten(long bytesWritten) {
        this.bytesWritten += bytesWritten;
        if (this.bytesWritten > (long)(12 + this.hdrLen + this.dataLen + this.msgLen)) {
            String errorMessage = "Too many bytes written (expected: " + (12 + this.hdrLen + this.dataLen + this.msgLen) + ", actual: " + this.bytesWritten + ") for message " + this.requestHeader;
            Logging.logMessage(3, this, errorMessage, new Object[0]);
            throw new IllegalStateException(errorMessage);
        }
    }

    public void checkEnoughBytesSent() {
        if (this.bytesWritten != (long)(12 + this.hdrLen + this.dataLen + this.msgLen)) {
            String errorMessage = "Not enough bytes written (expected: " + (12 + this.hdrLen + this.dataLen + this.msgLen) + ", actual: " + this.bytesWritten + ") for message " + this.requestHeader;
            Logging.logMessage(3, this, errorMessage, new Object[0]);
            throw new IllegalStateException(errorMessage);
        }
    }
}

