/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.client;

import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCClientRequest;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;

public class RPCResponse<V extends Message>
implements RPCResponseListener<V> {
    private static final boolean TRACE_DUPLICATE_RESPONSES = false;
    private RPCClientRequest request;
    private RPCResponseAvailableListener<V> listener;
    private String errorMessage;
    private boolean failed = false;
    private final V responsePrototype;
    private Object attachment;
    private ReusableBuffer message;
    private ReusableBuffer data;

    public RPCResponse(V responsePrototype) {
        this.responsePrototype = responsePrototype;
    }

    public void freeBuffers() {
        if (this.request != null) {
            this.request.freeBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(RPCResponseAvailableListener<V> listener) {
        RPCResponse rPCResponse = this;
        synchronized (rPCResponse) {
            this.listener = listener;
            if (this.request != null || this.failed) {
                listener.responseAvailable(this);
            }
        }
    }

    public V get() throws IOException, InterruptedException {
        this.waitForResult();
        if (this.failed) {
            throw new IOException(this.errorMessage);
        }
        if (this.request.getResponseHeader().getMessageType() == RPC.MessageType.RPC_RESPONSE_SUCCESS) {
            if (this.responsePrototype != null) {
                if (this.message != null) {
                    ReusableBufferInputStream rbis = new ReusableBufferInputStream(this.message);
                    Message responseObject = this.responsePrototype.newBuilderForType().mergeFrom(rbis).build();
                    assert (responseObject != null);
                    BufferPool.free(this.message);
                    this.message = null;
                    return (V)responseObject;
                }
                return (V)this.responsePrototype.getDefaultInstanceForType();
            }
            if (this.message != null) {
                throw new RuntimeException("specify response prototype for null message!");
            }
            return null;
        }
        RPC.RPCHeader.ErrorResponse err = this.request.getResponseHeader().getErrorResponse();
        throw new PBRPCException(err);
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public ReusableBuffer getData() throws InterruptedException {
        this.waitForResult();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResult() throws InterruptedException {
        RPCResponse rPCResponse = this;
        synchronized (rPCResponse) {
            if (this.request == null && !this.failed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseAvailable(RPCClientRequest<V> request, ReusableBuffer message, ReusableBuffer data) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, "response received", new Object[0]);
        }
        RPCResponse rPCResponse = this;
        synchronized (rPCResponse) {
            this.message = message;
            this.data = data;
            this.request = request;
            if (this.listener != null) {
                this.listener.responseAvailable(this);
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFailed(String errorMessage) {
        RPCResponse rPCResponse = this;
        synchronized (rPCResponse) {
            this.failed = true;
            this.errorMessage = errorMessage;
            if (this.listener != null) {
                this.listener.responseAvailable(this);
            }
            this.notify();
        }
    }

    public long getDuration() {
        return this.request.getDuration();
    }
}

