/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.generatedinterfaces;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.Ping;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class PingServiceClient {
    private RPCNIOSocketClient client;
    private InetSocketAddress defaultServer;

    public PingServiceClient(RPCNIOSocketClient client, InetSocketAddress defaultServer) {
        this.client = client;
        this.defaultServer = defaultServer;
    }

    public RPCResponse<Ping.PingResponse> doPing(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Ping.PingRequest input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Ping.PingResponse> response = new RPCResponse<Ping.PingResponse>(Ping.PingResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 1, 1, input, data, response, false);
        return response;
    }

    public RPCResponse<Ping.PingResponse> doPing(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String text, boolean sendError, ReusableBuffer data) throws IOException {
        Ping.PingRequest msg = Ping.PingRequest.newBuilder().setText(text).setSendError(sendError).build();
        return this.doPing(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse emptyPing(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Ping.Ping_emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 1, 2, input, null, response, false);
        return response;
    }

    public RPCResponse emptyPing(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.emptyPing(server, authHeader, userCreds, null);
    }

    public boolean clientIsAlive() {
        return this.client.isAlive();
    }
}

