/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.server;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.channels.ChannelIO;
import org.xtreemfs.foundation.pbrpc.server.RPCServerConnectionInterface;
import org.xtreemfs.foundation.pbrpc.server.RPCServerInterface;
import org.xtreemfs.foundation.pbrpc.server.RPCServerResponse;

public class RPCNIOSocketServerConnection
implements RPCServerConnectionInterface {
    private final AtomicInteger openRequests;
    private Queue<RPCServerResponse> pendingResponses;
    private final ChannelIO channel;
    private final ByteBuffer receiveRecordMarker;
    private final ByteBuffer sendFragHdr;
    private ReusableBuffer[] receiveBuffers;
    private ReceiveState receiveState;
    private ByteBuffer[] sendBuffers;
    private volatile boolean connectionClosed;
    private SocketAddress clientAddress;
    private RPCServerInterface server;
    private long bytesSent;
    private int expectedRecordSize;

    public RPCNIOSocketServerConnection(RPCServerInterface server, ChannelIO channel) {
        assert (server != null);
        assert (channel != null);
        this.channel = channel;
        this.openRequests = new AtomicInteger(0);
        this.pendingResponses = new ConcurrentLinkedQueue<RPCServerResponse>();
        this.connectionClosed = false;
        this.receiveRecordMarker = ByteBuffer.allocate(12);
        this.sendFragHdr = ByteBuffer.allocate(12);
        this.receiveState = ReceiveState.RECORD_MARKER;
        this.server = server;
        try {
            this.clientAddress = channel.socket().getRemoteSocketAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReceiveState getReceiveState() {
        return this.receiveState;
    }

    public void setReceiveState(ReceiveState receiveState) {
        this.receiveState = receiveState;
    }

    @Override
    public RPCServerInterface getServer() {
        return this.server;
    }

    @Override
    public SocketAddress getSender() {
        return this.clientAddress;
    }

    public void freeBuffers() {
        if (this.receiveBuffers != null) {
            for (ReusableBuffer buffer : this.receiveBuffers) {
                BufferPool.free(buffer);
            }
        }
        for (RPCServerResponse r : this.pendingResponses) {
            r.freeBuffers();
        }
    }

    public AtomicInteger getOpenRequests() {
        return this.openRequests;
    }

    @Override
    public ChannelIO getChannel() {
        return this.channel;
    }

    public boolean isConnectionClosed() {
        return this.connectionClosed;
    }

    public void setConnectionClosed(boolean connectionClosed) {
        this.connectionClosed = connectionClosed;
    }

    public Queue<RPCServerResponse> getPendingResponses() {
        return this.pendingResponses;
    }

    public void addPendingResponse(RPCServerResponse rq) {
        this.pendingResponses.add(rq);
    }

    ByteBuffer getReceiveRecordMarker() {
        return this.receiveRecordMarker;
    }

    ByteBuffer getSendFragHdr() {
        return this.sendFragHdr;
    }

    ReusableBuffer[] getReceiveBuffers() {
        return this.receiveBuffers;
    }

    void setReceiveBuffers(ReusableBuffer[] receive) {
        this.receiveBuffers = receive;
    }

    ByteBuffer[] getSendBuffers() {
        return this.sendBuffers;
    }

    void setSendBuffers(ByteBuffer[] send) {
        this.sendBuffers = send;
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setExpectedRecordSize(int expectedRecordSize) {
        this.expectedRecordSize = expectedRecordSize;
        this.bytesSent = 0L;
    }

    public void recordBytesSent(long bytesSent) {
        this.bytesSent += bytesSent;
        if (this.bytesSent > (long)this.expectedRecordSize) {
            String errorMessage = "Too many bytes written (expected: " + this.expectedRecordSize + ", actual: " + this.bytesSent + ") in connection to " + this.clientAddress;
            Logging.logMessage(3, this, errorMessage, new Object[0]);
            throw new IllegalStateException(errorMessage);
        }
    }

    public void checkEnoughBytesSent() {
        if (this.bytesSent != (long)this.expectedRecordSize) {
            String errorMessage = "Incorrect record length sent (expected: " + this.expectedRecordSize + ", actual: " + this.bytesSent + ") in connection to " + this.clientAddress;
            Logging.logMessage(3, this, errorMessage, new Object[0]);
            throw new IllegalStateException(errorMessage);
        }
    }

    public static enum ReceiveState {
        RECORD_MARKER,
        RPC_HEADER,
        RPC_MESSAGE,
        DATA;

    }
}

