/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.server;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.SocketAddress;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerConnectionInterface;
import org.xtreemfs.foundation.pbrpc.server.RPCServerResponse;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;

public class RPCServerRequest {
    private RPC.RPCHeader header;
    private ReusableBuffer message;
    private ReusableBuffer data;
    private final RPCServerConnectionInterface connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCServerRequest(RPCServerConnectionInterface connection, ReusableBuffer headerBuffer, ReusableBuffer message, ReusableBuffer data) throws IOException {
        try {
            ReusableBufferInputStream rbis = new ReusableBufferInputStream(headerBuffer);
            this.header = RPC.RPCHeader.parseFrom(rbis);
            this.message = message;
            this.data = data;
            this.connection = connection;
        }
        finally {
            BufferPool.free(headerBuffer);
        }
    }

    public RPCServerRequest(RPCServerConnectionInterface connection, RPC.RPCHeader header, ReusableBuffer message) {
        this.header = header;
        this.message = message;
        this.data = null;
        this.connection = connection;
    }

    public RPC.RPCHeader getHeader() {
        return this.header;
    }

    public ReusableBuffer getMessage() {
        return this.message;
    }

    public ReusableBuffer getData() {
        return this.data;
    }

    public void freeBuffers() {
        BufferPool.free(this.message);
        BufferPool.free(this.data);
    }

    public void sendError(RPC.ErrorType type, RPC.POSIXErrno errno, String message, String debugInfo) {
        RPC.RPCHeader.ErrorResponse resp = RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(type).setPosixErrno(errno).setErrorMessage(message).setDebugInfo(debugInfo).build();
        this.sendError(resp);
    }

    public void sendError(RPC.ErrorType type, RPC.POSIXErrno errno, String message) {
        RPC.RPCHeader.ErrorResponse resp = RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(type).setPosixErrno(errno).setErrorMessage(message).build();
        this.sendError(resp);
    }

    public void sendRedirect(String target_uuid) {
        RPC.RPCHeader.ErrorResponse resp = RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(RPC.ErrorType.REDIRECT).setPosixErrno(RPC.POSIXErrno.POSIX_ERROR_NONE).setRedirectToServerUuid(target_uuid).build();
        this.sendError(resp);
    }

    public void sendError(RPC.RPCHeader.ErrorResponse error) {
        try {
            RPC.RPCHeader rqHdr = this.getHeader();
            RPC.RPCHeader respHdr = RPC.RPCHeader.newBuilder().setCallId(rqHdr.getCallId()).setMessageType(RPC.MessageType.RPC_RESPONSE_ERROR).setErrorResponse(error).build();
            RPCServerResponse response = new RPCServerResponse(respHdr, null, null);
            this.getConnection().getServer().sendResponse(this, response);
        }
        catch (IOException ex) {
            Logging.logError(3, this, ex);
        }
    }

    public void sendResponse(Message message, ReusableBuffer data) throws IOException {
        RPC.RPCHeader rqHdr = this.getHeader();
        RPC.RPCHeader respHdr = RPC.RPCHeader.newBuilder().setCallId(rqHdr.getCallId()).setMessageType(RPC.MessageType.RPC_RESPONSE_SUCCESS).build();
        RPCServerResponse response = new RPCServerResponse(respHdr, message, data);
        this.getConnection().getServer().sendResponse(this, response);
    }

    public SocketAddress getSenderAddress() {
        return this.connection.getSender();
    }

    public RPCServerConnectionInterface getConnection() {
        return this.connection;
    }

    public String toString() {
        try {
            RPC.RPCHeader hdr = this.getHeader();
            String headerContent = "";
            if (hdr.getMessageType() == RPC.MessageType.RPC_REQUEST) {
                headerContent = ",proc=" + hdr.getRequestHeader().getProcId() + ",interf=" + hdr.getRequestHeader().getInterfaceId();
            }
            return this.getClass().getCanonicalName() + ": callid=" + hdr.getCallId() + ", type=" + hdr.getMessageType() + headerContent;
        }
        catch (Exception ex) {
            return this.getClass().getCanonicalName() + ": unparseable data: " + ex;
        }
    }
}

