/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.server;

import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.RecordMarker;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferOutputStream;

public class RPCServerResponse {
    final int callId;
    final ReusableBuffer[] buffers;
    final int hdrLen;
    final int msgLen;
    final int dataLen;

    public RPCServerResponse(RPC.RPCHeader header, Message message, ReusableBuffer data) throws IOException {
        ReusableBufferOutputStream os = new ReusableBufferOutputStream(8192);
        this.callId = header.getCallId();
        this.hdrLen = header.getSerializedSize();
        this.msgLen = message != null ? message.getSerializedSize() : 0;
        int n = this.dataLen = data != null ? data.capacity() : 0;
        assert (this.hdrLen > 0);
        assert (this.msgLen >= 0);
        assert (this.dataLen >= 0);
        RecordMarker rm = new RecordMarker(this.hdrLen, this.msgLen, this.dataLen);
        rm.writeFragmentHeader(os);
        header.writeTo(os);
        if (message != null) {
            message.writeTo(os);
        }
        if (data != null) {
            data.position(data.limit());
            os.appendBuffer(data);
        }
        os.flip();
        this.buffers = os.getBuffers();
    }

    public ReusableBuffer[] getBuffers() {
        return this.buffers;
    }

    public ByteBuffer[] packBuffers(ByteBuffer recordMarker) {
        ByteBuffer[] arr = new ByteBuffer[this.buffers.length];
        for (int i = 0; i < this.buffers.length; ++i) {
            arr[i] = this.buffers[i].getBuffer();
        }
        return arr;
    }

    public void freeBuffers() {
        for (int i = 0; i < this.buffers.length; ++i) {
            BufferPool.free(this.buffers[i]);
            this.buffers[i] = null;
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ": callid=" + this.callId;
    }

    public int getRpcMessageSize() {
        return 12 + this.hdrLen + this.dataLen + this.msgLen;
    }
}

