/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.utils;

import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;

public class ErrorUtils {
    public static RPC.RPCHeader.ErrorResponse getErrorResponse(RPC.ErrorType type, RPC.POSIXErrno errno, String message, String debug) {
        return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(type).setPosixErrno(errno).setErrorMessage(message).setDebugInfo(debug).build();
    }

    public static RPC.RPCHeader.ErrorResponse getErrorResponse(RPC.ErrorType type, RPC.POSIXErrno errno, String message, Throwable cause) {
        return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(type).setPosixErrno(errno).setErrorMessage(message).setDebugInfo(OutputUtils.stackTraceToString(cause)).build();
    }

    public static RPC.RPCHeader.ErrorResponse getErrorResponse(RPC.ErrorType type, RPC.POSIXErrno errno, String message) {
        return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(type).setPosixErrno(errno).setErrorMessage(message).build();
    }

    public static RPC.RPCHeader.ErrorResponse getInternalServerError(Throwable cause) {
        return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(RPC.ErrorType.INTERNAL_SERVER_ERROR).setPosixErrno(RPC.POSIXErrno.POSIX_ERROR_EIO).setErrorMessage(cause.toString()).setDebugInfo(OutputUtils.stackTraceToString(cause)).build();
    }

    public static RPC.RPCHeader.ErrorResponse getInternalServerError(Throwable cause, String additionalErrorMessage) {
        return RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(RPC.ErrorType.INTERNAL_SERVER_ERROR).setPosixErrno(RPC.POSIXErrno.POSIX_ERROR_EIO).setErrorMessage(additionalErrorMessage + "; " + cause.toString()).setDebugInfo(OutputUtils.stackTraceToString(cause)).build();
    }

    public static String formatError(RPC.RPCHeader.ErrorResponse error) {
        if (error == null) {
            return "no error";
        }
        return error.getErrorType() + "/" + error.getPosixErrno() + ": " + error.getErrorMessage() + (error.hasDebugInfo() ? ";\n" + error.getDebugInfo() : "");
    }
}

