/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.utils;

import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.RecordMarker;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferOutputStream;

public class PBRPCDatagramPacket {
    private final RPC.RPCHeader header;
    private final Message message;

    public PBRPCDatagramPacket(ReusableBuffer datagramToParse, Message msgPrototype) throws IOException {
        RecordMarker rm = new RecordMarker(datagramToParse.getBuffer());
        ReusableBufferInputStream rbis = new ReusableBufferInputStream(datagramToParse);
        int origLimit = datagramToParse.limit();
        assert (origLimit == 12 + rm.getRpcHeaderLength() + rm.getMessageLength());
        datagramToParse.limit(12 + rm.getRpcHeaderLength());
        this.header = ((RPC.RPCHeader.Builder)RPC.RPCHeader.newBuilder().mergeFrom(rbis)).build();
        datagramToParse.limit(origLimit);
        this.message = msgPrototype.newBuilderForType().mergeFrom(rbis).build();
    }

    public PBRPCDatagramPacket(RPC.RPCHeader header, Message message) {
        this.header = header;
        this.message = message;
    }

    public ReusableBuffer assembleDatagramPacket() throws IOException {
        ReusableBufferOutputStream out = new ReusableBufferOutputStream(12 + this.getHeader().getSerializedSize() + this.getMessage().getSerializedSize());
        RecordMarker rm = new RecordMarker(this.getHeader().getSerializedSize(), this.getMessage().getSerializedSize(), 0);
        rm.writeFragmentHeader(out);
        this.getHeader().writeTo(out);
        this.getMessage().writeTo(out);
        out.flip();
        ReusableBuffer[] bufs = out.getBuffers();
        assert (bufs.length == 1);
        return bufs[0];
    }

    public RPC.RPCHeader getHeader() {
        return this.header;
    }

    public Message getMessage() {
        return this.message;
    }
}

