/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferOutputStream;

public class RecordMarker {
    public static final int HDR_SIZE = 12;
    private final int rpcHeaderLength;
    private final int messageLength;
    private final int dataLength;

    public RecordMarker(ByteBuffer buf) throws IOException {
        this.rpcHeaderLength = buf.getInt();
        this.messageLength = buf.getInt();
        this.dataLength = buf.getInt();
    }

    public RecordMarker(int rpcHeaderLength, int messageLength, int dataLength) {
        this.rpcHeaderLength = rpcHeaderLength;
        this.messageLength = messageLength;
        this.dataLength = dataLength;
    }

    public void writeFragmentHeader(ByteBuffer buf) {
        buf.putInt(this.getRpcHeaderLength());
        buf.putInt(this.getMessageLength());
        buf.putInt(this.getDataLength());
    }

    public void writeFragmentHeader(ReusableBufferOutputStream out) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.putInt(this.getRpcHeaderLength());
        buf.putInt(this.getMessageLength());
        buf.putInt(this.getDataLength());
        out.write(buf.array());
    }

    public int getRpcHeaderLength() {
        return this.rpcHeaderLength;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }
}

